/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.cache.file.FileCache;
import org.apache.jetspeed.cache.file.FileCacheEntry;
import org.apache.jetspeed.cache.file.FileCacheEventListener;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.om.page.Document;
import org.apache.jetspeed.om.page.psml.AbstractBaseElement;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.AbstractNode;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentHandler;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.FailedToDeleteDocumentException;
import org.apache.jetspeed.page.document.FailedToUpdateDocumentException;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeNotFoundException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CastorFileSystemDocumentHandler
implements DocumentHandler,
FileCacheEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$page$document$CastorFileSystemDocumentHandler == null ? (class$org$apache$jetspeed$page$document$CastorFileSystemDocumentHandler = CastorFileSystemDocumentHandler.class$("org.apache.jetspeed.page.document.CastorFileSystemDocumentHandler")) : class$org$apache$jetspeed$page$document$CastorFileSystemDocumentHandler));
    protected String mappingFile;
    protected String documentType;
    protected Class expectedReturnType;
    protected String documentRoot;
    protected File documentRootDir;
    protected FileCache fileCache;
    protected Mapping mapping = null;
    private OutputFormat format;
    private DocumentHandlerFactory handlerFactory;
    static /* synthetic */ Class class$org$apache$jetspeed$page$document$CastorFileSystemDocumentHandler;

    public CastorFileSystemDocumentHandler(String mappingFile, String documentType, Class expectedReturnType, String documentRoot, FileCache fileCache) throws FileNotFoundException {
        this.mappingFile = mappingFile;
        this.documentType = documentType;
        this.expectedReturnType = expectedReturnType;
        this.documentRoot = documentRoot;
        this.documentRootDir = new File(documentRoot);
        this.verifyPath(this.documentRootDir);
        this.fileCache = fileCache;
        this.fileCache.addListener((FileCacheEventListener)this);
        this.format = new OutputFormat();
        this.format.setIndenting(true);
        this.format.setIndent(4);
        this.format.setEncoding("UTF-8");
        this.loadMapping();
    }

    public CastorFileSystemDocumentHandler(String mappingFile, String documentType, String expectedReturnType, String documentRoot, FileCache fileCache) throws FileNotFoundException, ClassNotFoundException {
        this(mappingFile, documentType, Class.forName(expectedReturnType), documentRoot, fileCache);
    }

    public Document getDocument(String name) throws NodeException, DocumentNotFoundException {
        return this.getDocument(name, true);
    }

    public void updateDocument(Document document) throws FailedToUpdateDocumentException {
        if (document == null) {
            log.warn((Object)"Recieved null Document to update");
            return;
        }
        String path = document.getPath();
        if (path == null) {
            path = document.getId();
            if (path == null) {
                log.warn((Object)"Recieved Document with null path/id to update");
                return;
            }
            document.setPath(path);
        }
        AbstractBaseElement documentImpl = (AbstractBaseElement)document;
        documentImpl.setHandlerFactory(this.handlerFactory);
        documentImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
        documentImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
        String fileName = path;
        if (!fileName.endsWith(this.documentType)) {
            fileName = path + this.documentType;
        }
        File f = new File(this.documentRootDir, fileName);
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            XMLSerializer serializer = new XMLSerializer((Writer)writer, this.format);
            Marshaller marshaller = new Marshaller(serializer.asDocumentHandler());
            marshaller.setMapping(this.mapping);
            marshaller.marshal((Object)document);
        }
        catch (MarshalException e) {
            log.error((Object)("Could not marshal the file " + f.getAbsolutePath()), (Throwable)e);
            throw new FailedToUpdateDocumentException((Throwable)e);
        }
        catch (MappingException e) {
            log.error((Object)("Could not marshal the file " + f.getAbsolutePath()), (Throwable)e);
            throw new FailedToUpdateDocumentException((Throwable)e);
        }
        catch (ValidationException e) {
            log.error((Object)("Document " + f.getAbsolutePath() + " is not valid"), (Throwable)e);
            throw new FailedToUpdateDocumentException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Could not save the file " + f.getAbsolutePath()), (Throwable)e);
            throw new FailedToUpdateDocumentException((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Error while saving  " + f.getAbsolutePath()), (Throwable)e);
            throw new FailedToUpdateDocumentException((Throwable)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
    }

    protected void loadMapping() {
        try {
            InputStream stream = this.getClass().getResourceAsStream(this.mappingFile);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading psml mapping file " + this.mappingFile));
            }
            this.mapping = new Mapping();
            InputSource is = new InputSource(stream);
            is.setSystemId(this.mappingFile);
            this.mapping.loadMapping(is);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Error in psml mapping creation");
            ise.initCause(e);
            throw ise;
        }
    }

    protected Object unmarshallDocument(Class clazz, String path, String extension) throws NodeNotFoundException, DocumentException {
        Document document = null;
        File f = null;
        f = path.endsWith(extension) ? new File(this.documentRootDir, path) : new File(this.documentRootDir, path + extension);
        if (!f.exists()) {
            throw new PageNotFoundException("Document not found: " + path);
        }
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            org.w3c.dom.Document d = builder.parse(f);
            Unmarshaller unmarshaller = new Unmarshaller(this.mapping);
            document = (Document)unmarshaller.unmarshal((org.w3c.dom.Node)d);
            document.setId(path);
            document.setPath(path);
            AbstractBaseElement documentImpl = (AbstractBaseElement)document;
            documentImpl.setHandlerFactory(this.handlerFactory);
            documentImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
            documentImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
        }
        catch (IOException e) {
            throw new PageNotFoundException("Could not load the file " + f.getAbsolutePath(), (Throwable)e);
        }
        catch (MarshalException e) {
            throw new PageNotFoundException("Could not unmarshal the file " + f.getAbsolutePath(), (Throwable)e);
        }
        catch (MappingException e) {
            throw new PageNotFoundException("Could not unmarshal the file " + f.getAbsolutePath(), (Throwable)e);
        }
        catch (ValidationException e) {
            throw new DocumentNotFoundException("Document " + f.getAbsolutePath() + " is not valid", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PageNotFoundException("Could not unmarshal the file " + f.getAbsolutePath(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new PageNotFoundException("Could not unmarshal the file " + f.getAbsolutePath(), (Throwable)e);
        }
        if (document == null) {
            throw new DocumentNotFoundException("Document not found: " + path);
        }
        if (!clazz.isAssignableFrom(document.getClass())) {
            throw new ClassCastException(document.getClass().getName() + " must implement or extend " + clazz.getName());
        }
        return document;
    }

    protected void verifyPath(File path) throws FileNotFoundException {
        if (path == null) {
            throw new IllegalArgumentException("Page root cannot be null");
        }
        if (!path.exists()) {
            throw new FileNotFoundException("Could not locate root pages path " + path.getAbsolutePath());
        }
    }

    public void removeDocument(Document document) throws DocumentNotFoundException, FailedToDeleteDocumentException {
        if (document == null) {
            log.warn((Object)"Recieved null Document to remove");
            return;
        }
        String path = document.getPath();
        if (path == null && (path = document.getId()) == null) {
            log.warn((Object)"Recieved Document with null path/id to remove");
            return;
        }
        String fileName = path;
        if (!fileName.endsWith(this.documentType)) {
            fileName = path + this.documentType;
        }
        File file = new File(this.documentRootDir, fileName);
        file.delete();
    }

    public Document getDocument(String name, boolean fromCache) throws NodeException {
        Document document = null;
        if (fromCache) {
            Object obj = this.fileCache.getDocument(name);
            document = (Document)obj;
            if (document == null) {
                document = (Document)this.unmarshallDocument(this.expectedReturnType, name, this.documentType);
                this.addToCache(name, document);
            }
        } else {
            document = (Document)this.unmarshallDocument(this.expectedReturnType, name, this.documentType);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToCache(String path, Object objectToCache) {
        FileCache fileCache = this.fileCache;
        synchronized (fileCache) {
            try {
                this.fileCache.put(path, objectToCache, this.documentRootDir);
            }
            catch (IOException e) {
                log.error((Object)("Error putting document: " + e));
                IllegalStateException ise = new IllegalStateException("Error storing Document in the FileCache: " + e.toString());
                ise.initCause(e);
            }
        }
    }

    public void refresh(FileCacheEntry entry) throws Exception {
        log.debug((Object)("Entry is refreshing: " + entry.getFile().getName()));
        if (entry.getDocument() instanceof Document && ((Document)entry.getDocument()).getPath().endsWith(this.documentType)) {
            Document document = (Document)entry.getDocument();
            Document freshDoc = this.getDocument(document.getPath(), false);
            Node parent = ((AbstractNode)document).getParent(false);
            freshDoc.setParent(parent);
            if (parent instanceof FolderImpl) {
                FolderImpl folder = (FolderImpl)parent;
                folder.getAllNodes().add((Node)freshDoc);
            }
            freshDoc.setPath(document.getPath());
            entry.setDocument((Object)freshDoc);
        }
    }

    public void evict(FileCacheEntry entry) throws Exception {
    }

    public String getType() {
        return this.documentType;
    }

    public DocumentHandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public void setHandlerFactory(DocumentHandlerFactory factory) {
        this.handlerFactory = factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

