/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.om.common.LocalizedField;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.psml.AbstractBaseElement;
import org.apache.jetspeed.om.page.psml.PageMetadataImpl;
import org.apache.jetspeed.om.page.psml.SecurityConstraintsImpl;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.util.ArgUtil;

public abstract class AbstractNode
extends AbstractBaseElement
implements Node {
    private Collection metadataFields = null;
    private Map localizedTitles;
    private Map localizedShortTitles;
    private Node parent;
    private String path;
    private String url;
    private boolean hidden = false;
    private String profiledPath;
    static /* synthetic */ Class class$java$util$Locale;

    public GenericMetadata getMetadata() {
        if (this.metadataFields == null) {
            this.metadataFields = new ArrayList();
        }
        PageMetadataImpl metadata = new PageMetadataImpl();
        metadata.setFields(this.metadataFields);
        return metadata;
    }

    public void setMetadata(GenericMetadata metadata) {
        this.metadataFields = metadata.getFields();
    }

    public Collection getMetadataFields() {
        return this.metadataFields;
    }

    public void setMetadataFields(Collection metadataFields) {
        this.metadataFields = metadataFields;
    }

    public String getTitle(Locale locale) {
        ArgUtil.assertNotNull((Class)(class$java$util$Locale == null ? (class$java$util$Locale = AbstractNode.class$("java.util.Locale")) : class$java$util$Locale), (Object)locale, (Object)this, (String)"getTile(Locale)");
        if (this.localizedTitles == null && this.metadataFields != null) {
            this.localizedTitles = new HashMap(this.metadataFields.size());
            Iterator fieldsItr = this.metadataFields.iterator();
            while (fieldsItr.hasNext()) {
                LocalizedField field = (LocalizedField)fieldsItr.next();
                if (!field.getName().equals("title")) continue;
                this.localizedTitles.put(field.getLocale(), field);
            }
        }
        Locale languageOnly = new Locale(locale.getLanguage());
        if (this.localizedTitles != null && (this.localizedTitles.containsKey(locale) || this.localizedTitles.containsKey(languageOnly))) {
            if (this.localizedTitles.containsKey(locale)) {
                return ((LocalizedField)this.localizedTitles.get(locale)).getValue().trim();
            }
            if (this.localizedTitles.containsKey(languageOnly)) {
                return ((LocalizedField)this.localizedTitles.get(languageOnly)).getValue().trim();
            }
        }
        return this.getTitle();
    }

    public String getShortTitle(Locale locale) {
        String title;
        ArgUtil.assertNotNull((Class)(class$java$util$Locale == null ? (class$java$util$Locale = AbstractNode.class$("java.util.Locale")) : class$java$util$Locale), (Object)locale, (Object)this, (String)"getShortTitle(Locale)");
        if (this.localizedShortTitles == null && this.metadataFields != null) {
            this.localizedShortTitles = new HashMap(this.metadataFields.size());
            Iterator fieldsItr = this.metadataFields.iterator();
            while (fieldsItr.hasNext()) {
                LocalizedField field = (LocalizedField)fieldsItr.next();
                if (!field.getName().equals("short-title")) continue;
                this.localizedShortTitles.put(field.getLocale(), field);
            }
        }
        Locale languageOnly = new Locale(locale.getLanguage());
        if (this.localizedShortTitles != null && (this.localizedShortTitles.containsKey(locale) || this.localizedShortTitles.containsKey(languageOnly))) {
            if (this.localizedShortTitles.containsKey(locale)) {
                return ((LocalizedField)this.localizedShortTitles.get(locale)).getValue().trim();
            }
            if (this.localizedShortTitles.containsKey(languageOnly)) {
                return ((LocalizedField)this.localizedShortTitles.get(languageOnly)).getValue().trim();
            }
        }
        if ((title = this.getTitle(locale)) == this.getTitle()) {
            title = this.getShortTitle();
        }
        return title;
    }

    public Node getParent(boolean checkAccess) {
        AbstractNode parent = (AbstractNode)this.parent;
        if (parent != null && checkAccess) {
            parent.checkAccess("view");
        }
        return parent;
    }

    public Node getParent() {
        return this.getParent(false);
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public String getName() {
        String path = this.getPath();
        String parentName = "";
        if (this.getParent(false) != null && !(parentName = this.getParent(false).getPath()).endsWith("/")) {
            parentName = parentName + "/";
        }
        if (path.startsWith(parentName)) {
            return path.substring(parentName.length());
        }
        return path;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUrl() {
        if (this.isUrlSet()) {
            return this.url;
        }
        return this.getPath();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isUrlSet() {
        return this.url != null;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getProfiledPath() {
        return this.profiledPath;
    }

    public void setProfiledPath(String profiledPath) {
        this.profiledPath = profiledPath;
    }

    public void checkConstraints(List actions, List userPrincipals, List rolePrincipals, List groupPrincipals, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        String debug = "";
        Iterator i = actions.iterator();
        while (i.hasNext()) {
            debug = debug + (String)i.next() + " ";
        }
        if (checkNodeOnly) {
            SecurityConstraints constraints = this.getSecurityConstraints();
            if (constraints != null) {
                ((SecurityConstraintsImpl)constraints).checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, this.getHandlerFactory());
            } else if (this.parent != null) {
                ((AbstractNode)this.parent).checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, checkNodeOnly, false);
            }
        } else {
            SecurityConstraints constraints;
            if (!checkParentsOnly && (constraints = this.getSecurityConstraints()) != null) {
                ((SecurityConstraintsImpl)constraints).checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, this.getHandlerFactory());
            }
            if (this.parent != null) {
                ((AbstractNode)this.parent).checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, false, false);
            }
        }
    }

    public void checkPermissions(String path, String actions, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        if (!checkParentsOnly) {
            super.checkPermissions(path, actions, true, false);
        }
        if (!checkNodeOnly && this.parent != null) {
            ((AbstractNode)this.parent).checkPermissions(actions, false, false);
        }
    }

    public String getLogicalPermissionPath() {
        return this.profiledPath;
    }

    public String getPhysicalPermissionPath() {
        return this.path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

