/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.page.psml.SecurityConstraintImpl;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;

public class SecurityConstraintsImpl
implements SecurityConstraints {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$om$page$psml$SecurityConstraintsImpl == null ? (class$org$apache$jetspeed$om$page$psml$SecurityConstraintsImpl = SecurityConstraintsImpl.class$("org.apache.jetspeed.om.page.psml.SecurityConstraintsImpl")) : class$org$apache$jetspeed$om$page$psml$SecurityConstraintsImpl));
    private String owner;
    private List constraints;
    private List constraintsRefs;
    private List allConstraints;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$SecurityConstraintsImpl;

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List getSecurityConstraints() {
        return this.constraints;
    }

    public void setSecurityConstraints(List constraints) {
        this.constraints = constraints;
    }

    public List getSecurityConstraintsRefs() {
        return this.constraintsRefs;
    }

    public void setSecurityConstraintsRefs(List constraintsRefs) {
        this.constraintsRefs = constraintsRefs;
    }

    public void checkConstraints(List actions, List userPrincipals, List rolePrincipals, List groupPrincipals, DocumentHandlerFactory handlerFactory) throws SecurityException {
        if (this.owner != null && userPrincipals != null && userPrincipals.contains(this.owner)) {
            return;
        }
        List checkConstraints = this.getAllSecurityConstraints(handlerFactory);
        if (checkConstraints != null && !checkConstraints.isEmpty()) {
            Iterator actionsIter = actions.iterator();
            while (actionsIter.hasNext()) {
                String action = (String)actionsIter.next();
                boolean actionPermitted = false;
                boolean actionNotPermitted = false;
                boolean anyActionsPermitted = false;
                Iterator checkConstraintsIter = checkConstraints.iterator();
                while (checkConstraintsIter.hasNext()) {
                    SecurityConstraintImpl constraint = (SecurityConstraintImpl)checkConstraintsIter.next();
                    if (constraint.getPermissions() != null) {
                        anyActionsPermitted = true;
                        if (!constraint.actionMatch(action) || !constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, true)) continue;
                        actionPermitted = true;
                        break;
                    }
                    if (!constraint.principalsMatch(userPrincipals, rolePrincipals, groupPrincipals, false)) continue;
                    actionNotPermitted = true;
                    break;
                }
                if ((actionPermitted || !anyActionsPermitted) && !actionNotPermitted) continue;
                throw new SecurityException("SecurityConstraintsImpl.checkConstraints(): Access for " + action + " not permitted.");
            }
        }
    }

    private List getAllSecurityConstraints(DocumentHandlerFactory handlerFactory) {
        List referencedConstraints;
        List globalConstraintsRefs;
        PageSecurity pageSecurity;
        List referencedConstraints2;
        if (this.allConstraints != null) {
            return this.allConstraints;
        }
        this.allConstraints = new ArrayList(8);
        if (this.constraints != null) {
            this.allConstraints.addAll(this.constraints);
        }
        if (this.constraintsRefs != null && !this.constraintsRefs.isEmpty() && (referencedConstraints2 = this.dereferenceSecurityConstraintsRefs(this.constraintsRefs, handlerFactory)) != null) {
            this.allConstraints.addAll(referencedConstraints2);
        }
        if ((pageSecurity = this.getSecurity(handlerFactory)) != null && (globalConstraintsRefs = pageSecurity.getGlobalSecurityConstraintsRefs()) != null && !globalConstraintsRefs.isEmpty() && (referencedConstraints = this.dereferenceSecurityConstraintsRefs(globalConstraintsRefs, handlerFactory)) != null) {
            this.allConstraints.addAll(referencedConstraints);
        }
        return this.allConstraints;
    }

    private List dereferenceSecurityConstraintsRefs(List constraintsRefs, DocumentHandlerFactory handlerFactory) {
        ArrayList constraints = null;
        if (handlerFactory != null) {
            PageSecurity pageSecurity = this.getSecurity(handlerFactory);
            if (pageSecurity != null) {
                Iterator constraintsRefsIter = constraintsRefs.iterator();
                while (constraintsRefsIter.hasNext()) {
                    String constraintsRef = (String)constraintsRefsIter.next();
                    SecurityConstraintsDef securityConstraintsDef = pageSecurity.getSecurityConstraintsDef(constraintsRef);
                    if (securityConstraintsDef != null && securityConstraintsDef.getSecurityConstraints() != null) {
                        if (constraints == null) {
                            constraints = new ArrayList(constraintsRefs.size());
                        }
                        constraints.addAll(securityConstraintsDef.getSecurityConstraints());
                        continue;
                    }
                    log.error((Object)("dereferenceSecurityConstraintsRefs(): Unable to dereference \"" + constraintsRef + "\" security constraints definition."));
                }
            } else {
                log.error((Object)"dereferenceSecurityConstraintsRefs(): Failed to load page security configuration while dereferencing security constraints definitions.");
            }
        } else {
            log.error((Object)"dereferenceSecurityConstraintsRefs(): Missing document handler, unable to dereference security constraints definitions.");
        }
        return constraints;
    }

    private PageSecurity getSecurity(DocumentHandlerFactory handlerFactory) {
        if (handlerFactory != null) {
            String pageSecurityPath = "/page.security";
            try {
                return (PageSecurity)handlerFactory.getDocumentHandler("page.security").getDocument(pageSecurityPath);
            }
            catch (PageNotFoundException pnfe) {
                log.debug((Object)("getSecurity(): Failed to load page security configuration at " + pageSecurityPath + "."));
            }
            catch (Exception e) {
                log.error((Object)("getSecurity(): Failed to load page security configuration at " + pageSecurityPath + "."), (Throwable)e);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

