/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.io.Serializable;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.om.common.SecuredResource;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.BaseElement;
import org.apache.jetspeed.om.page.psml.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.psml.SecurityConstraintsImpl;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.NodeSetImpl;
import org.apache.jetspeed.security.FolderPermission;
import org.apache.jetspeed.security.GroupPrincipal;
import org.apache.jetspeed.security.PagePermission;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.UserPrincipal;

public abstract class AbstractBaseElement
implements Serializable,
SecuredResource {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$om$page$psml$AbstractBaseElement == null ? (class$org$apache$jetspeed$om$page$psml$AbstractBaseElement = AbstractBaseElement.class$("org.apache.jetspeed.om.page.psml.AbstractBaseElement")) : class$org$apache$jetspeed$om$page$psml$AbstractBaseElement));
    private String id = null;
    private String title = null;
    private String shortTitle = null;
    private boolean constraintsEnabled;
    private SecurityConstraints constraints = null;
    private boolean permissionsEnabled;
    private DocumentHandlerFactory handlerFactory = null;
    static /* synthetic */ Class class$org$apache$jetspeed$om$page$psml$AbstractBaseElement;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getShortTitle() {
        String title = this.shortTitle;
        if (title == null) {
            title = this.title;
        }
        return title;
    }

    public void setShortTitle(String title) {
        this.shortTitle = title;
    }

    public boolean getConstraintsEnabled() {
        return this.constraintsEnabled;
    }

    public void setConstraintsEnabled(boolean enabled) {
        this.constraintsEnabled = enabled;
    }

    public SecurityConstraints getSecurityConstraints() {
        return this.constraints;
    }

    public void setSecurityConstraints(SecurityConstraints constraints) {
        this.constraints = constraints;
    }

    public void checkConstraints(String actions) throws SecurityException {
        Subject subject;
        if (!this.getConstraintsEnabled()) {
            return;
        }
        if (actions == null) {
            throw new SecurityException("AbstractBaseElement.checkConstraints(): No actions specified.");
        }
        ArrayList<String> viewActionList = SecurityConstraintImpl.parseCSVList(actions);
        ArrayList<String> otherActionsList = null;
        if (viewActionList.size() == 1) {
            if (!viewActionList.contains("view")) {
                otherActionsList = viewActionList;
                viewActionList = null;
            }
        } else {
            otherActionsList = viewActionList;
            viewActionList = null;
            if (otherActionsList.remove("view")) {
                viewActionList = new ArrayList<String>(1);
                viewActionList.add("view");
            }
        }
        if ((subject = Subject.getSubject(AccessController.getContext())) == null) {
            throw new SecurityException("AbstractBaseElement.checkConstraints(): Missing Subject.");
        }
        LinkedList<String> userPrincipals = null;
        LinkedList<String> rolePrincipals = null;
        LinkedList<String> groupPrincipals = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal principal = principals.next();
            if (principal instanceof UserPrincipal) {
                if (userPrincipals == null) {
                    userPrincipals = new LinkedList<String>();
                }
                userPrincipals.add(principal.getName());
                continue;
            }
            if (principal instanceof RolePrincipal) {
                if (rolePrincipals == null) {
                    rolePrincipals = new LinkedList<String>();
                }
                rolePrincipals.add(principal.getName());
                continue;
            }
            if (!(principal instanceof GroupPrincipal)) continue;
            if (groupPrincipals == null) {
                groupPrincipals = new LinkedList<String>();
            }
            groupPrincipals.add(principal.getName());
        }
        if (viewActionList != null) {
            this.checkConstraints(viewActionList, userPrincipals, rolePrincipals, groupPrincipals, false, this.grantViewActionAccess());
        }
        if (otherActionsList != null) {
            this.checkConstraints(otherActionsList, userPrincipals, rolePrincipals, groupPrincipals, true, false);
        }
    }

    public void checkConstraints(List actions, List userPrincipals, List rolePrincipals, List groupPrincipals, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        SecurityConstraints constraints = this.getSecurityConstraints();
        if (constraints != null) {
            ((SecurityConstraintsImpl)constraints).checkConstraints(actions, userPrincipals, rolePrincipals, groupPrincipals, this.handlerFactory);
        }
    }

    public boolean getPermissionsEnabled() {
        return this.permissionsEnabled;
    }

    public void setPermissionsEnabled(boolean enabled) {
        this.permissionsEnabled = enabled;
    }

    public void checkPermissions(String actions) throws SecurityException {
        if (!this.getPermissionsEnabled()) {
            return;
        }
        boolean viewAction = false;
        String otherActions = actions.trim();
        int viewActionIndex = otherActions.indexOf("view");
        if (viewActionIndex != -1) {
            viewAction = true;
            if (viewActionIndex == 0) {
                if (otherActions.length() > "view".length()) {
                    int nextDelimIndex = otherActions.indexOf(44, viewActionIndex + "view".length());
                    otherActions = otherActions.substring(nextDelimIndex + 1);
                } else {
                    otherActions = null;
                }
            } else {
                int prevDelimIndex = otherActions.lastIndexOf(44, viewActionIndex);
                otherActions = otherActions.substring(0, prevDelimIndex) + otherActions.substring(viewActionIndex + "view".length());
            }
        }
        if (viewAction) {
            this.checkPermissions("view", false, this.grantViewActionAccess());
        }
        if (otherActions != null) {
            this.checkPermissions(otherActions, true, false);
        }
    }

    public void checkPermissions(String actions, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        String physicalPermissionPath = this.getPhysicalPermissionPath();
        if (physicalPermissionPath != null) {
            try {
                this.checkPermissions(physicalPermissionPath, actions, checkNodeOnly, checkParentsOnly);
            }
            catch (SecurityException physicalSE) {
                String logicalPermissionPath = this.getLogicalPermissionPath();
                if (logicalPermissionPath != null && !logicalPermissionPath.equals(physicalPermissionPath)) {
                    this.checkPermissions(logicalPermissionPath, actions, checkNodeOnly, checkParentsOnly);
                }
                throw physicalSE;
            }
        }
    }

    public void checkPermissions(String path, String actions, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        try {
            PagePermission permission = new PagePermission(path, actions);
            AccessController.checkPermission((Permission)permission);
        }
        catch (SecurityException se) {
            FolderPermission permission = new FolderPermission(path, actions);
            AccessController.checkPermission((Permission)permission);
        }
    }

    public String getLogicalPermissionPath() {
        return this.getPhysicalPermissionPath();
    }

    public String getPhysicalPermissionPath() {
        log.warn((Object)("getPhysicalPermissionPath(): no permission path available for " + this + " element."));
        return null;
    }

    public void checkAccess(String actions) throws SecurityException {
        if (this.getPermissionsEnabled()) {
            this.checkPermissions(actions);
        }
        if (this.getConstraintsEnabled()) {
            this.checkConstraints(actions);
        }
    }

    public boolean grantViewActionAccess() {
        return false;
    }

    public DocumentHandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public void setHandlerFactory(DocumentHandlerFactory factory) {
        this.handlerFactory = factory;
    }

    public Object clone() throws CloneNotSupportedException {
        Object cloned = super.clone();
        return cloned;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseElement) {
            AbstractBaseElement element = (AbstractBaseElement)obj;
            return this.id != null && element.getId() != null && this.id.equals(element.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getId();
    }

    public static NodeSet checkAccess(NodeSet nodes, String actions) {
        if (nodes != null && !nodes.isEmpty()) {
            NodeSetImpl filteredNodes = null;
            Iterator checkAccessIter = nodes.iterator();
            while (checkAccessIter.hasNext()) {
                AbstractBaseElement node = (AbstractBaseElement)checkAccessIter.next();
                try {
                    node.checkAccess(actions);
                    if (filteredNodes == null) continue;
                    filteredNodes.add((Node)node);
                }
                catch (SecurityException se) {
                    Node copyNode;
                    if (filteredNodes != null) continue;
                    filteredNodes = new NodeSetImpl(null, ((NodeSetImpl)nodes).getComparator());
                    Iterator copyIter = nodes.iterator();
                    while (copyIter.hasNext() && (copyNode = (Node)copyIter.next()) != node) {
                        filteredNodes.add(copyNode);
                    }
                }
            }
            if (filteredNodes != null) {
                return filteredNodes;
            }
        }
        return nodes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

