/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.folder.impl;

import java.io.File;
import java.security.AccessController;
import java.security.Permission;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.om.common.GenericMetadata;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.DocumentSet;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderMetaData;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.impl.FolderMetaDataImpl;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.AbstractNode;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.FolderHandler;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeOrderCompartaor;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.NodeSetImpl;
import org.apache.jetspeed.page.document.UnsupportedDocumentTypeException;
import org.apache.jetspeed.security.FolderPermission;

public class FolderImpl
extends AbstractNode
implements Folder {
    public static final String FALLBACK_DEFAULT_PAGE = "default-page.psml";
    private static final String PAGE_NOT_FOUND_PAGE = "page_not_found.psml";
    private static final String FOLDER_PERMISSION_WILD_CHAR = new String(new char[]{'*'});
    private String defaultTheme;
    private NodeSet allNodes;
    private File directory;
    private FolderMetaData metadata;
    private FolderHandler folderHandler;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$om$folder$impl$FolderImpl == null ? (class$org$apache$jetspeed$om$folder$impl$FolderImpl = FolderImpl.class$("org.apache.jetspeed.om.folder.impl.FolderImpl")) : class$org$apache$jetspeed$om$folder$impl$FolderImpl));
    static /* synthetic */ Class class$org$apache$jetspeed$om$folder$impl$FolderImpl;

    public FolderImpl(String path, FolderMetaData metadata, DocumentHandlerFactory handlerFactory, FolderHandler folderHandler) {
        this.metadata = metadata;
        this.metadata.setParent((Node)this);
        this.folderHandler = folderHandler;
        this.setId(path);
        this.setHandlerFactory(handlerFactory);
        this.setPermissionsEnabled(handlerFactory.getPermissionsEnabled());
        this.setConstraintsEnabled(handlerFactory.getConstraintsEnabled());
        this.setPath(path);
    }

    public FolderImpl(String path, DocumentHandlerFactory handlerFactory, FolderHandler folderHandler) {
        this.metadata = new FolderMetaDataImpl();
        this.metadata.setTitle(path);
        this.metadata.setParent((Node)this);
        this.folderHandler = folderHandler;
        this.setId(path);
        this.setHandlerFactory(handlerFactory);
        this.setPermissionsEnabled(handlerFactory.getPermissionsEnabled());
        this.setConstraintsEnabled(handlerFactory.getConstraintsEnabled());
        this.setPath(path);
    }

    public String getDefaultPage(boolean allowDefaulting) {
        try {
            String defaultPage = this.metadata.getDefaultPage();
            if (defaultPage == null) {
                defaultPage = FALLBACK_DEFAULT_PAGE;
            }
            return this.getPage(defaultPage, false).getName();
        }
        catch (NodeException e) {
            if (allowDefaulting) {
                try {
                    Iterator pagesIter = this.getPages(false).iterator();
                    if (pagesIter.hasNext()) {
                        return ((Page)pagesIter.next()).getName();
                    }
                    return PAGE_NOT_FOUND_PAGE;
                }
                catch (NodeException e1) {
                    return PAGE_NOT_FOUND_PAGE;
                }
            }
            return null;
        }
    }

    public void setDefaultPage(String defaultPage) {
        this.metadata.setDefaultPage(defaultPage);
    }

    public String getDefaultTheme() {
        return this.defaultTheme;
    }

    public void setDefaultTheme(String defaultTheme) {
        this.defaultTheme = defaultTheme;
    }

    public NodeSet getFolders(boolean checkAccess) throws FolderNotFoundException, DocumentException {
        NodeSet folders = this.getAllNodes().subset("folder");
        if (checkAccess) {
            folders = FolderImpl.checkAccess(folders, "view");
        }
        return folders;
    }

    public NodeSet getFolders() throws FolderNotFoundException, DocumentException {
        return this.getFolders(false);
    }

    public Folder getFolder(String name, boolean checkAccess) throws FolderNotFoundException, DocumentException {
        Folder folder = (Folder)this.getAllNodes().subset("folder").get(name);
        if (folder == null) {
            throw new FolderNotFoundException("Jetspeed PSML folder not found: " + name);
        }
        if (checkAccess) {
            folder.checkAccess("view");
        }
        return folder;
    }

    public Folder getFolder(String name) throws FolderNotFoundException, DocumentException {
        return this.getFolder(name, false);
    }

    public NodeSet getPages(boolean checkAccess) throws NodeException {
        NodeSet pages = this.getAllNodes().subset(".psml");
        if (checkAccess) {
            pages = FolderImpl.checkAccess(pages, "view");
        }
        return pages;
    }

    public NodeSet getPages() throws NodeException {
        return this.getPages(true);
    }

    public Page getPage(String name, boolean checkAccess) throws PageNotFoundException, NodeException {
        Page page = (Page)this.getAllNodes().subset(".psml").get(name);
        if (page == null) {
            throw new PageNotFoundException("Jetspeed PSML page not found: " + name);
        }
        if (checkAccess) {
            page.checkAccess("view");
        }
        return page;
    }

    public Page getPage(String name) throws PageNotFoundException, NodeException {
        return this.getPage(name, true);
    }

    public NodeSet getLinks(boolean checkAccess) throws NodeException {
        NodeSet links = this.getAllNodes().subset(".link");
        if (checkAccess) {
            links = FolderImpl.checkAccess(links, "view");
        }
        return links;
    }

    public NodeSet getLinks() throws NodeException {
        return this.getLinks(true);
    }

    public Link getLink(String name, boolean checkAccess) throws DocumentNotFoundException, NodeException {
        Link link = (Link)this.getAllNodes().subset(".link").get(name);
        if (link == null) {
            throw new DocumentNotFoundException("Jetspeed PSML link not found: " + name);
        }
        if (checkAccess) {
            link.checkAccess("view");
        }
        return link;
    }

    public Link getLink(String name) throws DocumentNotFoundException, NodeException {
        return this.getLink(name, true);
    }

    public NodeSet getDocumentSets(boolean checkAccess) throws NodeException {
        NodeSet documentSets = this.getAllNodes().subset(".ds");
        if (checkAccess) {
            documentSets = FolderImpl.checkAccess(documentSets, "view");
        }
        return documentSets;
    }

    public NodeSet getDocumentSets() throws NodeException {
        return this.getDocumentSets(true);
    }

    public DocumentSet getDocumentSet(String name, boolean checkAccess) throws DocumentNotFoundException, NodeException {
        DocumentSet documentSet = (DocumentSet)this.getAllNodes().subset(".ds").get(name);
        if (documentSet == null) {
            throw new DocumentNotFoundException("Jetspeed PSML document set not found: " + name);
        }
        if (checkAccess) {
            documentSet.checkAccess("view");
        }
        return documentSet;
    }

    public DocumentSet getDocumentSet(String name) throws DocumentNotFoundException, NodeException {
        return this.getDocumentSet(name, true);
    }

    public PageSecurity getPageSecurity(boolean checkAccess) throws DocumentNotFoundException, NodeException {
        PageSecurity pageSecurity;
        if (checkAccess) {
            this.checkAccess("view");
        }
        if ((pageSecurity = (PageSecurity)this.getAllNodes().subset("page.security").get("page.security")) == null) {
            throw new DocumentNotFoundException("Jetspeed PSML page security not found: page.security");
        }
        return pageSecurity;
    }

    public PageSecurity getPageSecurity() throws DocumentNotFoundException, NodeException {
        return this.getPageSecurity(false);
    }

    public NodeSet getAll() throws FolderNotFoundException, DocumentException {
        NodeSet nodes = this.getAllNodes();
        NodeSetImpl filteredNodes = null;
        Iterator checkAccessIter = nodes.iterator();
        while (checkAccessIter.hasNext()) {
            Node node = (Node)checkAccessIter.next();
            try {
                ((AbstractNode)node).checkAccess("view");
                if (filteredNodes == null) continue;
                filteredNodes.add(node);
            }
            catch (SecurityException se) {
                Node copyNode;
                if (filteredNodes != null) continue;
                filteredNodes = new NodeSetImpl(this.getPath(), ((NodeSetImpl)nodes).getComparator());
                Iterator copyIter = nodes.iterator();
                while (copyIter.hasNext() && (copyNode = (Node)copyIter.next()) != node) {
                    filteredNodes.add(copyNode);
                }
            }
        }
        if (filteredNodes != null) {
            return filteredNodes;
        }
        return nodes;
    }

    public NodeSet getAllNodes() throws FolderNotFoundException, DocumentException {
        if (this.allNodes == null) {
            this.allNodes = this.metadata.getDocumentOrder() != null ? (this.getPath().endsWith("/") ? new NodeSetImpl(this.getPath(), new NodeOrderCompartaor(this.metadata.getDocumentOrder(), this.getPath())) : new NodeSetImpl(this.getPath(), new NodeOrderCompartaor(this.metadata.getDocumentOrder(), this.getPath() + "/"))) : new NodeSetImpl(this.getPath());
            String[] nodeNames = this.folderHandler.listAll(this.getPath());
            for (int i = 0; i < nodeNames.length; ++i) {
                Object node = null;
                try {
                    node = this.getPath().endsWith("/") ? (nodeNames[i].indexOf(".") > -1 ? this.getHandlerFactory().getDocumentHandlerForPath(nodeNames[i]).getDocument(this.getPath() + nodeNames[i]) : this.folderHandler.getFolder(this.getPath() + nodeNames[i])) : (nodeNames[i].indexOf(".") > -1 ? this.getHandlerFactory().getDocumentHandlerForPath(nodeNames[i]).getDocument(this.getPath() + "/" + nodeNames[i]) : this.folderHandler.getFolder(this.getPath() + "/" + nodeNames[i]));
                    node.setParent((Node)this);
                    this.allNodes.add((Node)node);
                    continue;
                }
                catch (UnsupportedDocumentTypeException e) {
                    log.info((Object)("getAllNodes() Skipping unsupported document: " + nodeNames[i]));
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)("getAllNodes() failed to create Node: " + nodeNames[i] + ":" + e.toString()), (Throwable)e);
                }
            }
        }
        return this.allNodes;
    }

    public FolderMetaData getMetaData() {
        return this.metadata;
    }

    public GenericMetadata getMetadata() {
        return this.metadata.getMetadata();
    }

    public SecurityConstraints getSecurityConstraints() {
        return this.metadata.getSecurityConstraints();
    }

    public void setSecurityConstraints(SecurityConstraints constraints) {
        this.metadata.setSecurityConstraints(constraints);
    }

    public void checkPermissions(String path, String actions, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        if (!checkParentsOnly) {
            FolderPermission permission = new FolderPermission(path, actions);
            AccessController.checkPermission((Permission)permission);
        }
        if (!checkNodeOnly && this.getParent() != null) {
            ((AbstractNode)this.getParent()).checkPermissions(actions, false, false);
        }
    }

    public String getTitle(Locale locale) {
        return this.metadata.getTitle(locale);
    }

    public String getTitle() {
        return this.metadata.getTitle();
    }

    public void setTitle(String title) {
        this.metadata.setTitle(title);
    }

    public String getShortTitle(Locale locale) {
        return this.metadata.getShortTitle(locale);
    }

    public String getShortTitle() {
        return this.metadata.getShortTitle();
    }

    public void setShortTitle(String title) {
        this.metadata.setShortTitle(title);
    }

    public String getType() {
        return "folder";
    }

    public boolean isHidden() {
        return this.metadata.isHidden();
    }

    public void setHidden(boolean hidden) {
        ((AbstractNode)this.metadata).setHidden(hidden);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

