/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.ojb;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public class CSVtoCollectionFieldConversion
implements FieldConversion {
    private static final String DELIM = ",";
    private static final String QUOTE = "\"";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$util$ojb$CSVtoCollectionFieldConversion == null ? (class$org$apache$jetspeed$util$ojb$CSVtoCollectionFieldConversion = CSVtoCollectionFieldConversion.class$("org.apache.jetspeed.util.ojb.CSVtoCollectionFieldConversion")) : class$org$apache$jetspeed$util$ojb$CSVtoCollectionFieldConversion));
    static /* synthetic */ Class class$org$apache$jetspeed$util$ojb$CSVtoCollectionFieldConversion;

    public Object javaToSql(Object arg0) throws ConversionException {
        if (arg0 instanceof Collection) {
            Collection col = (Collection)arg0;
            if (col.size() == 0) {
                return "";
            }
            Iterator itr = col.iterator();
            StringBuffer buffer = new StringBuffer(col.size() * 5);
            while (itr.hasNext()) {
                buffer.append(QUOTE);
                String value = this.getNext(itr);
                if (value != null && value.toString().indexOf(QUOTE) >= 0) {
                    log.warn((Object)("In CSVtoCollectionFieldConversion() - The string '" + value + "' contains embeded '\"'.  It will not be converted to a CSV correctly."));
                }
                buffer.append(value);
                buffer.append(QUOTE);
                if (!itr.hasNext()) continue;
                buffer.append(DELIM);
            }
            return buffer.toString();
        }
        return arg0;
    }

    public Object sqlToJava(Object arg0) throws ConversionException {
        if (arg0 instanceof String) {
            StringReader sr = new StringReader((String)arg0);
            StreamTokenizer st = new StreamTokenizer(sr);
            st.resetSyntax();
            st.whitespaceChars(44, 44);
            st.quoteChar(34);
            st.eolIsSignificant(false);
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                while (st.nextToken() != -1) {
                    list.add(this.createObject(st.sval));
                    log.debug((Object)("Parsed token value: " + st.sval));
                }
            }
            catch (IOException e) {
                String message = "CSV parsing failed during field conversion.";
                log.error((Object)message, (Throwable)e);
                throw new ConversionException("CSV parsing failed during field conversion.", (Throwable)e);
            }
            return list;
        }
        return arg0;
    }

    protected Object createObject(String name) {
        return name;
    }

    protected String getNext(Iterator iterator) {
        return (String)iterator.next();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

