/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.persistence.store.ojb.pb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.components.persistence.store.Transaction;
import org.apache.jetspeed.components.persistence.store.TransactionEventListener;
import org.apache.jetspeed.components.persistence.store.impl.TransactionEventInvoker;
import org.apache.jetspeed.components.persistence.store.ojb.pb.PBStore;

public class PBTransaction
implements Transaction {
    private List eventListeners;
    private TransactionEventInvoker invoker;
    private PBStore store;

    public PBTransaction(PBStore store) {
        this.store = store;
        this.eventListeners = new ArrayList();
        this.invoker = new TransactionEventInvoker(this.eventListeners, store);
    }

    public void begin() {
        if (!this.store.getBroker().isInTransaction()) {
            this.invoker.beforeBegin();
            this.store.getBroker().beginTransaction();
            this.invoker.afterBegin();
        }
    }

    public void commit() {
        this.invoker.beforeCommit();
        Iterator itr = this.store.toBeStored.iterator();
        while (itr.hasNext()) {
            this.store.store(itr.next());
        }
        this.store.getBroker().commitTransaction();
        this.invoker.afterCommit();
    }

    public void rollback() {
        this.invoker.beforeRollback();
        this.store.getBroker().abortTransaction();
        this.invoker.afterRollback();
    }

    public void checkpoint() {
        this.store.checkBroker();
        Iterator itr = this.store.toBeStored.iterator();
        while (itr.hasNext()) {
            this.store.store(itr.next());
        }
    }

    public boolean isOpen() {
        return this.store.getBroker().isInTransaction();
    }

    public Object getWrappedTransaction() {
        return this.store.getBroker();
    }

    public void addEventListener(TransactionEventListener listener) {
        this.eventListeners.add(listener);
    }
}

