/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.persistence.store.ojb.pb;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.persistence.store.Filter;
import org.apache.jetspeed.components.persistence.store.LockFailedException;
import org.apache.jetspeed.components.persistence.store.PersistenceStore;
import org.apache.jetspeed.components.persistence.store.PersistenceStoreEventListener;
import org.apache.jetspeed.components.persistence.store.RemovalAware;
import org.apache.jetspeed.components.persistence.store.Transaction;
import org.apache.jetspeed.components.persistence.store.UpdateAware;
import org.apache.jetspeed.components.persistence.store.impl.StoreEventInvoker;
import org.apache.jetspeed.components.persistence.store.ojb.CriteriaFilter;
import org.apache.jetspeed.components.persistence.store.ojb.pb.PBTransaction;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.RepositoryPersistor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;

public class PBStore
implements PersistenceStore {
    private PBKey pbKey;
    private static final Set listeners = new HashSet();
    private StoreEventInvoker invoker;
    private PersistenceBroker pb;
    protected Set toBeStored;
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$components$persistence$store$ojb$pb$PBStore == null ? (class$org$apache$jetspeed$components$persistence$store$ojb$pb$PBStore = PBStore.class$("org.apache.jetspeed.components.persistence.store.ojb.pb.PBStore")) : class$org$apache$jetspeed$components$persistence$store$ojb$pb$PBStore));
    static /* synthetic */ Class class$org$apache$jetspeed$components$persistence$store$ojb$pb$PBStore;

    public PBStore(String jcd) {
        block3: {
            try {
                this.pbKey = new PBKey(jcd);
                this.pbKey = jcd != null ? new PBKey(jcd) : PersistenceBrokerFactory.getDefaultKey();
                this.invoker = new StoreEventInvoker(listeners, this);
                this.pb = PersistenceBrokerFactory.createPersistenceBroker((PBKey)this.pbKey);
                this.toBeStored = new HashSet();
                MetadataManager metaManager = MetadataManager.getInstance();
                RepositoryPersistor persistor = new RepositoryPersistor();
                Enumeration<URL> descriptors = this.getClass().getClassLoader().getResources("META-INF/ojb_repository.xml");
                while (descriptors.hasMoreElements()) {
                    URL descriptorUrl = descriptors.nextElement();
                    log.info((Object)("Merging OJB respository: " + descriptorUrl));
                    DescriptorRepository repo = persistor.readDescriptorRepository(descriptorUrl.openStream());
                    metaManager.mergeDescriptorRepository(repo);
                }
            }
            catch (Throwable e) {
                System.out.println("==========================>" + e.getCause());
                if (e.getCause() == null) break block3;
                e.getCause().printStackTrace();
            }
        }
    }

    public void addEventListener(PersistenceStoreEventListener listener) {
        listeners.add(listener);
    }

    public void close() {
        this.invoker.beforeClose();
        if (!this.pb.isClosed()) {
            this.pb.close();
        }
        this.invoker.afterClose();
    }

    public void deletePersistent(Object obj) throws LockFailedException {
        this.checkBroker();
        this.invoker.beforeDeletePersistent(obj);
        RemovalAware ra = null;
        if (obj instanceof RemovalAware) {
            ra = (RemovalAware)obj;
            ra.preRemoval((PersistenceStore)this);
        }
        this.pb.delete(obj);
        if (ra != null) {
            ra.postRemoval((PersistenceStore)this);
        }
        this.invoker.afterDeletePersistent(obj);
    }

    public void deleteAll(Object query) throws LockFailedException {
        this.checkBroker();
        Collection deletes = this.pb.getCollectionByQuery((Query)query);
        Iterator itr = deletes.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            this.deletePersistent(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getCollectionByQuery(Object query) {
        this.invoker.beforeLookup();
        Collection result = null;
        try {
            this.checkBroker();
            Collection collection = result = this.pb.getCollectionByQuery((Query)query);
            this.invoker.afterLookup(result);
            return collection;
        }
        catch (Throwable throwable) {
            this.invoker.afterLookup(result);
            throw throwable;
        }
    }

    protected void checkBroker() {
        try {
            if (this.pb.isClosed()) {
                this.pb = PersistenceBrokerFactory.createPersistenceBroker((PBKey)this.pbKey);
            }
        }
        catch (IllegalStateException e) {
            this.pb = PersistenceBrokerFactory.createPersistenceBroker((PBKey)this.pbKey);
        }
    }

    protected PersistenceBroker getBroker() {
        this.checkBroker();
        return this.pb;
    }

    public Collection getCollectionByQuery(Object query, int lockLevel) {
        return this.getCollectionByQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectByQuery(Object query) {
        this.invoker.beforeLookup();
        Object result = null;
        try {
            this.checkBroker();
            Object object = result = this.pb.getObjectByQuery((Query)query);
            this.invoker.afterLookup(result);
            return object;
        }
        catch (Throwable throwable) {
            this.invoker.afterLookup(result);
            throw throwable;
        }
    }

    public Object getObjectByQuery(Object query, int lockLevel) {
        return this.getObjectByQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectByIdentity(Object object) throws LockFailedException {
        this.invoker.beforeLookup();
        Object result = null;
        try {
            this.checkBroker();
            Object object2 = result = this.pb.getObjectByIdentity(new Identity(object, this.pb));
            this.invoker.afterLookup(result);
            return object2;
        }
        catch (Throwable throwable) {
            this.invoker.afterLookup(result);
            throw throwable;
        }
    }

    public Object getObjectByIdentity(Object object, int lockLevel) throws LockFailedException {
        return this.getObjectByIdentity(object);
    }

    public int getCount(Object query) {
        this.checkBroker();
        return this.pb.getCount((Query)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getIteratorByQuery(Object query) {
        this.invoker.beforeLookup();
        Iterator result = null;
        try {
            this.checkBroker();
            Iterator iterator = result = this.pb.getIteratorByQuery((Query)query);
            this.invoker.afterLookup(result);
            return iterator;
        }
        catch (Throwable throwable) {
            this.invoker.afterLookup(result);
            throw throwable;
        }
    }

    public Iterator getIteratorByQuery(Object query, int lockLevel) {
        return this.getIteratorByQuery(query);
    }

    public boolean isClosed() {
        return this.pb.isClosed();
    }

    public Transaction getTransaction() {
        return new PBTransaction(this);
    }

    public void invalidate(Object obj) throws LockFailedException {
        this.pb.removeFromCache(obj);
    }

    public void invalidateExtent(Class clazz) throws LockFailedException {
        Iterator itr = this.pb.getCollectionByQuery((Query)QueryFactory.newQuery((Class)clazz, (Criteria)new Criteria())).iterator();
        while (itr.hasNext()) {
            this.invalidate(itr.next());
        }
    }

    public void invalidateByQuery(Object query) throws LockFailedException {
        Iterator itr = this.pb.getCollectionByQuery((Query)query).iterator();
        while (itr.hasNext()) {
            this.invalidate(itr.next());
        }
    }

    public void lockForWrite(Object obj) throws LockFailedException {
        this.toBeStored.add(obj);
    }

    public void makePersistent(Object obj) throws LockFailedException {
        this.store(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(Object obj) {
        try {
            this.checkBroker();
            this.invoker.beforeMakePersistent(obj);
            UpdateAware ua = null;
            if (obj instanceof UpdateAware) {
                ua = (UpdateAware)obj;
                ua.preUpdate((PersistenceStore)this);
            }
            this.pb.store(obj);
            if (ua != null) {
                ua.postUpdate((PersistenceStore)this);
            }
            this.invoker.afterMakePersistent(obj);
        }
        finally {
            this.toBeStored.remove(obj);
        }
    }

    public Filter newFilter() {
        return new CriteriaFilter();
    }

    public Object newQuery(Class clazz, Filter filter) {
        return QueryFactory.newQuery((Class)clazz, (Criteria)((CriteriaFilter)filter).getOjbCriteria());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getExtent(Class clazz) {
        this.invoker.beforeLookup();
        Collection result = null;
        try {
            this.checkBroker();
            Collection collection = result = this.pb.getCollectionByQuery((Query)QueryFactory.newQuery((Class)clazz, (Criteria)new Criteria()));
            this.invoker.afterLookup(result);
            return collection;
        }
        catch (Throwable throwable) {
            this.invoker.afterLookup(result);
            throw throwable;
        }
    }

    public Collection getExtent(Class clazz, int lockLevel) {
        return this.getExtent(clazz);
    }

    public void invalidateAll() throws LockFailedException {
        this.checkBroker();
        this.pb.clearCache();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

