/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.sso.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.security.BasePrincipal;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.om.InternalGroupPrincipal;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.om.impl.InternalCredentialImpl;
import org.apache.jetspeed.security.om.impl.InternalUserPrincipalImpl;
import org.apache.jetspeed.sso.SSOContext;
import org.apache.jetspeed.sso.SSOException;
import org.apache.jetspeed.sso.SSOPrincipal;
import org.apache.jetspeed.sso.SSOProvider;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.impl.SSOContextImpl;
import org.apache.jetspeed.sso.impl.SSOSiteImpl;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;

public class PersistenceBrokerSSOProvider
extends InitablePersistenceBrokerDaoSupport
implements SSOProvider {
    private Hashtable mapSite = new Hashtable();
    private String USER_PATH = "/user/";
    private String GROUP_PATH = "/group/";
    static /* synthetic */ Class class$org$apache$jetspeed$sso$impl$SSOSiteImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;
    static /* synthetic */ Class class$org$apache$jetspeed$security$spi$impl$DefaultPasswordCredentialImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$sso$impl$SSOPrincipalImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$security$om$impl$InternalGroupPrincipalImpl;

    public PersistenceBrokerSSOProvider(String repositoryPath) throws ClassNotFoundException {
        super(repositoryPath);
    }

    public Iterator getSites(String filter) {
        Criteria queryCriteria = new Criteria();
        QueryByCriteria query = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$sso$impl$SSOSiteImpl == null ? (class$org$apache$jetspeed$sso$impl$SSOSiteImpl = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.sso.impl.SSOSiteImpl")) : class$org$apache$jetspeed$sso$impl$SSOSiteImpl), (Criteria)queryCriteria);
        Collection c = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return c.iterator();
    }

    public void addCredentialsForSite(String fullPath, String remoteUser, String site, String pwd) throws SSOException {
        GroupPrincipalImpl principal = null;
        String name = null;
        if (fullPath.indexOf("/group/") > -1) {
            name = fullPath.substring(this.GROUP_PATH.length());
            principal = new GroupPrincipalImpl(name);
        } else {
            name = fullPath.substring(this.USER_PATH.length());
            principal = new UserPrincipalImpl(name);
        }
        HashSet<GroupPrincipalImpl> principals = new HashSet<GroupPrincipalImpl>();
        principals.add(principal);
        Subject subject = new Subject(true, principals, new HashSet(), new HashSet());
        this.addCredentialsForSite(subject, remoteUser, site, pwd);
    }

    public void removeCredentialsForSite(String fullPath, String site) throws SSOException {
        GroupPrincipalImpl principal = null;
        String name = null;
        if (fullPath.indexOf("/group/") > -1) {
            name = fullPath.substring(this.GROUP_PATH.length());
            principal = new GroupPrincipalImpl(name);
        } else {
            name = fullPath.substring(this.USER_PATH.length());
            principal = new UserPrincipalImpl(name);
        }
        HashSet<GroupPrincipalImpl> principals = new HashSet<GroupPrincipalImpl>();
        principals.add(principal);
        Subject subject = new Subject(true, principals, new HashSet(), new HashSet());
        this.removeCredentialsForSite(subject, site);
    }

    public String getSiteURL(String site) {
        return site;
    }

    public String getSiteName(String site) {
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            return ssoSite.getName();
        }
        return null;
    }

    public boolean hasSSOCredentials(Subject subject, String site) {
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            return false;
        }
        BasePrincipal principal = (BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal));
        String fullPath = principal.getFullPath();
        Collection remoteForSite = ssoSite.getRemotePrincipals();
        Collection principalsForSite = ssoSite.getPrincipals();
        if (principalsForSite == null || remoteForSite == null) {
            return false;
        }
        Collection remoteForPrincipals = this.getRemotePrincipalsForPrincipal(principalsForSite, fullPath);
        if (remoteForPrincipals == null) {
            return false;
        }
        return this.findRemoteMatch(remoteForPrincipals, remoteForSite) != null;
    }

    public SSOContext getCredentials(Subject subject, String site) throws SSOException {
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        BasePrincipal principal = (BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal));
        String fullPath = principal.getFullPath();
        SSOContext context = this.getCredential(ssoSite, fullPath);
        if (context == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        return context;
    }

    public void addCredentialsForSite(Subject subject, String remoteUser, String site, String pwd) throws SSOException {
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            ssoSite = new SSOSiteImpl();
            ssoSite.setSiteURL(site);
            ssoSite.setName(site);
            ssoSite.setCertificateRequired(false);
            ssoSite.setAllowUserSet(true);
        }
        String fullPath = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal))).getFullPath();
        String principalName = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal))).getName();
        SSOPrincipal principal = this.getPrincipalForSite(ssoSite, fullPath);
        if (principal == null) {
            principal = this.getSSOPrincipal(fullPath);
            ssoSite.addPrincipal(principal);
        } else {
            Collection remoteForPrincipals;
            Collection remoteForSite = ssoSite.getRemotePrincipals();
            Collection principalsForSite = ssoSite.getPrincipals();
            if (remoteForSite != null && principalsForSite != null && (remoteForPrincipals = this.getRemotePrincipalsForPrincipal(principalsForSite, fullPath)) != null && this.findRemoteMatch(remoteForPrincipals, remoteForSite) != null) {
                throw new SSOException("Remote principal for site/principal already exists. Call update instead");
            }
        }
        if (principal == null) {
            throw new SSOException("Could not add Principal from SITE mapping table.");
        }
        InternalUserPrincipalImpl remotePrincipal = new InternalUserPrincipalImpl(remoteUser);
        if (fullPath.indexOf("/group/") > -1) {
            remotePrincipal.setFullPath("/sso/" + ssoSite.getSiteId() + "/group/" + principalName + "/" + remoteUser);
        } else {
            remotePrincipal.setFullPath("/sso/" + ssoSite.getSiteId() + "/user/" + principalName + "/" + remoteUser);
        }
        InternalCredentialImpl credential = new InternalCredentialImpl(remotePrincipal.getPrincipalId(), pwd, 0, (class$org$apache$jetspeed$security$spi$impl$DefaultPasswordCredentialImpl == null ? (class$org$apache$jetspeed$security$spi$impl$DefaultPasswordCredentialImpl = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.security.spi.impl.DefaultPasswordCredentialImpl")) : class$org$apache$jetspeed$security$spi$impl$DefaultPasswordCredentialImpl).getName());
        if (remotePrincipal.getCredentials() == null) {
            remotePrincipal.setCredentials(new ArrayList(0));
        }
        remotePrincipal.getCredentials().add(credential);
        principal.addRemotePrincipal((InternalUserPrincipal)remotePrincipal);
        ssoSite.getRemotePrincipals().add(remotePrincipal);
        try {
            this.getPersistenceBrokerTemplate().store((Object)ssoSite);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SSOException("Failed to store site info in database." + e.toString());
        }
        this.mapSite.put(site, ssoSite);
    }

    public void removeCredentialsForSite(Subject subject, String site) throws SSOException {
        InternalUserPrincipal remotePrincipal = null;
        Object principal = null;
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        String fullPath = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal))).getFullPath();
        try {
            Collection principalsForSite = ssoSite.getPrincipals();
            Collection remoteForSite = ssoSite.getRemotePrincipals();
            if (principalsForSite == null || remoteForSite == null) {
                throw new SSOException("The site has no Single Sign On credentails attached.");
            }
            Collection remoteForPrincipals = this.getRemotePrincipalsForPrincipal(principalsForSite, fullPath);
            if (remoteForPrincipals == null) {
                throw new SSOException("The site has no Single Sign On credentails attached.");
            }
            remotePrincipal = this.findRemoteMatch(remoteForPrincipals, remoteForSite);
            if (remotePrincipal == null) {
                throw new SSOException("The site has no Single Sign On credentails attached.");
            }
            ssoSite.getRemotePrincipals().remove(remotePrincipal);
            remoteForPrincipals.remove(remotePrincipal);
            this.getPersistenceBrokerTemplate().delete((Object)remotePrincipal);
        }
        catch (SSOException ssoex) {
            throw new SSOException((Throwable)ssoex);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SSOException("Failed to store site info in database." + e.toString());
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)ssoSite);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SSOException("Failed to store site info in database." + e.toString());
        }
    }

    public void updateCredentialsForSite(Subject subject, String remoteUser, String site, String pwd) throws SSOException {
        InternalUserPrincipal remotePrincipal = null;
        SSOSite ssoSite = this.getSSOSiteObject(site);
        if (ssoSite == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        String fullPath = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal))).getFullPath();
        String principalName = ((BasePrincipal)SecurityHelper.getBestPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal))).getName();
        Collection principalsForSite = ssoSite.getPrincipals();
        Collection remoteForSite = ssoSite.getRemotePrincipals();
        if (principalsForSite == null || remoteForSite == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        Collection remoteForPrincipals = this.getRemotePrincipalsForPrincipal(principalsForSite, fullPath);
        if (remoteForPrincipals == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        remotePrincipal = this.findRemoteMatch(remoteForPrincipals, remoteForSite);
        if (remotePrincipal == null) {
            throw new SSOException("The site has no Single Sign On credentails attached.");
        }
        remotePrincipal.setFullPath("/sso/user/" + principalName + "/" + remoteUser);
        InternalCredential credential = (InternalCredential)remotePrincipal.getCredentials().iterator().next();
        if (credential != null) {
            credential.setValue(pwd);
        }
        try {
            this.getPersistenceBrokerTemplate().store((Object)ssoSite);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SSOException("Failed to store site info in database." + e.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SSOSite getSSOSiteObject(String site) {
        SSOSite ssoSite = null;
        if (this.mapSite.containsKey(site)) return (SSOSite)this.mapSite.get(site);
        Criteria filter = new Criteria();
        filter.addEqualTo("siteURL", (Object)site);
        QueryByCriteria query = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$sso$impl$SSOSiteImpl == null ? (class$org$apache$jetspeed$sso$impl$SSOSiteImpl = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.sso.impl.SSOSiteImpl")) : class$org$apache$jetspeed$sso$impl$SSOSiteImpl), (Criteria)filter);
        Collection ssoSiteCollection = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        if (ssoSiteCollection == null) return null;
        if (ssoSiteCollection.isEmpty()) return null;
        Iterator itSite = ssoSiteCollection.iterator();
        if (itSite.hasNext()) {
            ssoSite = (SSOSite)itSite.next();
        }
        this.mapSite.put(site, ssoSite);
        return ssoSite;
    }

    private SSOContext getCredential(SSOSite ssoSite, String fullPath) {
        InternalCredential credential = null;
        InternalUserPrincipal remotePrincipal = null;
        Object remoteUser = null;
        Object remoteFullPath = null;
        Collection principalsForSite = ssoSite.getPrincipals();
        Collection remoteForSite = ssoSite.getRemotePrincipals();
        if (principalsForSite == null || remoteForSite == null) {
            return null;
        }
        Collection remoteForPrincipals = this.getRemotePrincipalsForPrincipal(principalsForSite, fullPath);
        if (remoteForPrincipals == null) {
            return null;
        }
        remotePrincipal = this.findRemoteMatch(remoteForPrincipals, remoteForSite);
        if (remotePrincipal == null) {
            return null;
        }
        if (remotePrincipal.getCredentials() != null) {
            credential = (InternalCredential)remotePrincipal.getCredentials().iterator().next();
        }
        if (credential == null) {
            System.out.println("Warning: Remote User " + remotePrincipal.getFullPath() + " doesn't have a credential");
            return null;
        }
        String name = this.stripPrincipalName(remotePrincipal.getFullPath());
        SSOContextImpl context = new SSOContextImpl(credential.getPrincipalId(), name, credential.getValue());
        return context;
    }

    private String stripPrincipalName(String fullPath) {
        int ix = fullPath.lastIndexOf(47);
        String name = ix != -1 ? fullPath.substring(ix + 1) : new String(fullPath);
        return name;
    }

    private Collection getRemotePrincipalsForPrincipal(SSOSite ssoSite, String fullPath) {
        Collection principals = ssoSite.getPrincipals();
        if (principals == null) {
            return null;
        }
        Iterator ixPrincipals = principals.iterator();
        while (ixPrincipals.hasNext()) {
            SSOPrincipal principal = (SSOPrincipal)ixPrincipals.next();
            if (principal == null || principal.getFullPath().compareToIgnoreCase(fullPath) != 0) continue;
            return principal.getRemotePrincipals();
        }
        return null;
    }

    private SSOPrincipal getPrincipalForSite(SSOSite ssoSite, String fullPath) {
        SSOPrincipal principal = null;
        Collection principalsForSite = ssoSite.getPrincipals();
        if (principalsForSite != null) {
            Iterator itPrincipals = principalsForSite.iterator();
            while (itPrincipals.hasNext() && principal == null) {
                SSOPrincipal tmp = (SSOPrincipal)itPrincipals.next();
                if (tmp == null || tmp.getFullPath().compareToIgnoreCase(fullPath) != 0) continue;
                principal = tmp;
            }
        }
        return principal;
    }

    private SSOPrincipal getSSOPrincipal(String fullPath) {
        Iterator itPrincipals;
        SSOPrincipal principal = null;
        Criteria filter = new Criteria();
        filter.addEqualTo("fullPath", (Object)fullPath);
        QueryByCriteria query = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$sso$impl$SSOPrincipalImpl == null ? (class$org$apache$jetspeed$sso$impl$SSOPrincipalImpl = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.sso.impl.SSOPrincipalImpl")) : class$org$apache$jetspeed$sso$impl$SSOPrincipalImpl), (Criteria)filter);
        Collection principals = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        if (principals != null && !principals.isEmpty() && (itPrincipals = principals.iterator()).hasNext()) {
            principal = (SSOPrincipal)itPrincipals.next();
        }
        return principal;
    }

    private InternalUserPrincipal removeRemotePrincipalForPrincipal(SSOSite site, String fullPath) throws SSOException {
        if (site.getPrincipals() != null) {
            Iterator itPrincipals = site.getPrincipals().iterator();
            while (itPrincipals.hasNext()) {
                Iterator itRemotePrincipals;
                Collection collRemotePrincipals;
                SSOPrincipal tmp = (SSOPrincipal)itPrincipals.next();
                if (tmp.getFullPath().compareToIgnoreCase(fullPath) != 0 || (collRemotePrincipals = tmp.getRemotePrincipals()) == null || !(itRemotePrincipals = collRemotePrincipals.iterator()).hasNext()) continue;
                InternalUserPrincipal remotePrincipal = (InternalUserPrincipal)itRemotePrincipals.next();
                collRemotePrincipals.remove(remotePrincipal);
                return remotePrincipal;
            }
        }
        throw new SSOException("Requested principal doesn't exist in Principal store.");
    }

    private InternalUserPrincipal findRemoteMatch(Collection remoteForPrincipals, Collection remoteForSite) {
        Iterator itRemoteForPrincipals = remoteForPrincipals.iterator();
        while (itRemoteForPrincipals.hasNext()) {
            InternalUserPrincipal remoteForPrincipal = (InternalUserPrincipal)itRemoteForPrincipals.next();
            Iterator itRemoteForSite = remoteForSite.iterator();
            while (itRemoteForSite.hasNext()) {
                InternalUserPrincipal tmp = (InternalUserPrincipal)itRemoteForSite.next();
                if (tmp.getPrincipalId() != remoteForPrincipal.getPrincipalId()) continue;
                return remoteForPrincipal;
            }
        }
        return null;
    }

    private Collection getRemotePrincipalsForPrincipal(Collection principalsForSite, String fullPath) {
        if (principalsForSite != null) {
            Iterator itPrincipalsForSite = principalsForSite.iterator();
            while (itPrincipalsForSite.hasNext()) {
                String principalFullPath = null;
                SSOPrincipal principal = (SSOPrincipal)itPrincipalsForSite.next();
                principalFullPath = principal.getFullPath();
                if (principalFullPath.indexOf("/group/") == -1) {
                    if (principalFullPath.compareToIgnoreCase(fullPath) != 0) continue;
                    return principal.getRemotePrincipals();
                }
                if (principalFullPath.compareToIgnoreCase(fullPath) == 0) {
                    return principal.getRemotePrincipals();
                }
                InternalGroupPrincipal groupPrincipal = this.getGroupPrincipals(principalFullPath);
                if (groupPrincipal == null) continue;
                Collection usersInGroup = groupPrincipal.getUserPrincipals();
                Iterator itUsers = usersInGroup.iterator();
                while (itUsers.hasNext()) {
                    InternalUserPrincipal user = (InternalUserPrincipal)itUsers.next();
                    if (user.getFullPath().compareToIgnoreCase(fullPath) != 0) continue;
                    return principal.getRemotePrincipals();
                }
            }
        }
        return null;
    }

    public SSOSite getSite(String siteUrl) {
        Criteria filter = new Criteria();
        filter.addEqualTo("url", (Object)siteUrl);
        QueryByCriteria query = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$sso$impl$SSOSiteImpl == null ? (class$org$apache$jetspeed$sso$impl$SSOSiteImpl = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.sso.impl.SSOSiteImpl")) : class$org$apache$jetspeed$sso$impl$SSOSiteImpl), (Criteria)filter);
        SSOSite site = (SSOSite)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        return site;
    }

    public void updateSite(SSOSite site) throws SSOException {
        try {
            this.getPersistenceBrokerTemplate().store((Object)site);
            this.mapSite.put(site.getName(), site);
        }
        catch (Exception e) {
            String msg = "Unable to remove SSO Site: " + site.getName();
            this.logger.error((Object)msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    public void addSite(String siteName, String siteUrl) throws SSOException {
        try {
            SSOSiteImpl ssoSite = new SSOSiteImpl();
            ssoSite.setSiteURL(siteUrl);
            ssoSite.setName(siteName);
            ssoSite.setCertificateRequired(false);
            ssoSite.setAllowUserSet(true);
            this.getPersistenceBrokerTemplate().store((Object)ssoSite);
            this.mapSite.put(siteName, ssoSite);
        }
        catch (Exception e) {
            String msg = "Unable to remove SSO Site: " + siteName;
            this.logger.error((Object)msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    public void removeSite(SSOSite site) throws SSOException {
        try {
            this.getPersistenceBrokerTemplate().delete((Object)site);
            this.mapSite.remove(site);
        }
        catch (Exception e) {
            String msg = "Unable to remove SSO Site: " + site.getName();
            this.logger.error((Object)msg, (Throwable)e);
            throw new SSOException(msg, (Throwable)e);
        }
    }

    public List getPrincipalsForSite(SSOSite site) {
        ArrayList<SSOContextImpl> list = new ArrayList<SSOContextImpl>();
        Iterator principals = site.getRemotePrincipals().iterator();
        while (principals.hasNext()) {
            InternalUserPrincipal remotePrincipal = (InternalUserPrincipal)principals.next();
            String fullpath = remotePrincipal.getFullPath();
            Iterator creds = remotePrincipal.getCredentials().iterator();
            while (creds.hasNext()) {
                InternalCredential cred = (InternalCredential)creds.next();
                SSOContextImpl context = new SSOContextImpl(remotePrincipal.getPrincipalId(), this.stripPrincipalName(remotePrincipal.getFullPath()), cred.getValue(), this.stripPortalPrincipalName(remotePrincipal.getFullPath()));
                list.add(context);
            }
        }
        return list;
    }

    private String stripPortalPrincipalName(String fullPath) {
        StringTokenizer tokenizer = new StringTokenizer(fullPath, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equals("user") && !token.equals("group") || !tokenizer.hasMoreTokens()) continue;
            return tokenizer.nextToken();
        }
        return fullPath;
    }

    private InternalGroupPrincipal getGroupPrincipals(String principalFullPath) {
        Criteria filter = new Criteria();
        filter.addEqualTo("fullPath", (Object)principalFullPath);
        QueryByCriteria query = QueryFactory.newQuery((Class)(class$org$apache$jetspeed$security$om$impl$InternalGroupPrincipalImpl == null ? (class$org$apache$jetspeed$security$om$impl$InternalGroupPrincipalImpl = PersistenceBrokerSSOProvider.class$("org.apache.jetspeed.security.om.impl.InternalGroupPrincipalImpl")) : class$org$apache$jetspeed$security$om$impl$InternalGroupPrincipalImpl), (Criteria)filter);
        InternalGroupPrincipal group = (InternalGroupPrincipal)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        return group;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

