/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.messaging;

import java.io.NotSerializableException;
import java.io.Serializable;
import javax.portlet.PortletRequest;

public class PortletMessaging {
    public static final void publish(PortletRequest request, String portletTopic, String messageName, Object message) throws NotSerializableException {
        String key = portletTopic + ":" + messageName;
        if (!(message instanceof Serializable)) {
            throw new NotSerializableException("Message not serializable for " + key);
        }
        request.getPortletSession().setAttribute(key, message, 1);
    }

    public static final Object consume(PortletRequest request, String portletTopic, String messageName) throws NotSerializableException {
        String key = portletTopic + ":" + messageName;
        Object object = request.getPortletSession().getAttribute(key, 1);
        request.getPortletSession().removeAttribute(key, 1);
        return object;
    }

    public static final Object receive(PortletRequest request, String portletTopic, String messageName) throws NotSerializableException {
        String key = portletTopic + ":" + messageName;
        Object object = request.getPortletSession().getAttribute(key, 1);
        return object;
    }

    public static final void cancel(PortletRequest request, String portletTopic, String messageName) throws NotSerializableException {
        String key = portletTopic + ":" + messageName;
        request.getPortletSession().removeAttribute(key, 1);
    }

    public static final void publish(PortletRequest request, String messageName, Object message) throws NotSerializableException {
        String key = messageName;
        if (!(message instanceof Serializable)) {
            throw new NotSerializableException("Message not serializable for " + key);
        }
        request.getPortletSession().setAttribute(key, message, 2);
    }

    public static final Object consume(PortletRequest request, String messageName) throws NotSerializableException {
        String key = messageName;
        Object object = request.getPortletSession().getAttribute(key, 2);
        request.getPortletSession().removeAttribute(key, 2);
        return object;
    }

    public static final Object receive(PortletRequest request, String messageName) throws NotSerializableException {
        String key = messageName;
        Object object = request.getPortletSession().getAttribute(key, 2);
        return object;
    }

    public static final void cancel(PortletRequest request, String messageName) throws NotSerializableException {
        String key = messageName;
        request.getPortletSession().removeAttribute(key, 2);
    }
}

