/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.commons.validator.Var;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.validator.Resources;
import org.apache.velocity.tools.struts.StrutsUtils;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class ValidatorTool
implements ViewTool {
    protected ViewContext context;
    protected ServletContext app;
    protected HttpServletRequest request;
    protected HttpSession session;
    protected ValidatorResources resources;
    private static final String HTML_BEGIN_COMMENT = "\n<!-- Begin \n";
    private static final String HTML_END_COMMENT = "//End --> \n";
    private boolean xhtml = false;
    private boolean htmlComment = true;
    private boolean cdata = true;
    private String formName = null;
    private String methodName = null;
    private String src = null;
    private int page = 0;

    public void init(Object object) {
        ActionConfig actionConfig;
        if (!(object instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        this.context = (ViewContext)object;
        this.request = this.context.getRequest();
        this.session = this.request.getSession(false);
        this.app = this.context.getServletContext();
        Boolean bl = (Boolean)this.context.getAttribute("XHTML");
        if (bl != null) {
            this.xhtml = bl;
        }
        if ((actionConfig = (ActionConfig)this.request.getAttribute("org.apache.struts.action.mapping.instance")) != null) {
            this.formName = actionConfig.getAttribute();
        }
        ModuleConfig moduleConfig = RequestUtils.getModuleConfig((HttpServletRequest)this.request, (ServletContext)this.app);
        this.resources = (ValidatorResources)this.app.getAttribute("org.apache.commons.validator.VALIDATOR_RESOURCES" + moduleConfig.getPrefix());
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String string) {
        this.methodName = string;
    }

    public boolean getHtmlComment() {
        return this.htmlComment;
    }

    public void setHtmlComment(boolean bl) {
        this.htmlComment = bl;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String string) {
        this.src = string;
    }

    public boolean getCdata() {
        return this.cdata;
    }

    public void setCdata(boolean bl) {
        this.cdata = bl;
    }

    public String getJavascript() throws Exception {
        return this.getJavascript(this.formName);
    }

    public String getJavascript(String string) throws Exception {
        this.formName = string;
        return this.getJavascript(string, true);
    }

    public String getDynamicJavascript() throws Exception {
        return this.getDynamicJavascript(this.formName);
    }

    public String getStaticJavascript() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStartElement());
        if (this.htmlComment) {
            stringBuffer.append(HTML_BEGIN_COMMENT);
        }
        stringBuffer.append(this.getJavascriptStaticMethods(this.resources));
        stringBuffer.append(this.getJavascriptEnd());
        return stringBuffer.toString();
    }

    public String getDynamicJavascript(String string) throws Exception {
        this.formName = string;
        return this.getJavascript(string, false);
    }

    protected String getJavascript(String string, boolean bl) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        Locale locale = StrutsUtils.getLocale(this.request, this.session);
        Form form = this.resources.get(locale, (Object)string);
        if (form != null) {
            stringBuffer.append(this.getDynamicJavascript(this.resources, locale, form));
        }
        if (bl) {
            stringBuffer.append(this.getJavascriptStaticMethods(this.resources));
        }
        if (form != null) {
            stringBuffer.append(this.getJavascriptEnd());
        }
        return stringBuffer.toString();
    }

    protected String getDynamicJavascript(ValidatorResources validatorResources, Locale locale, Form form) {
        StringBuffer stringBuffer = new StringBuffer();
        MessageResources messageResources = StrutsUtils.getMessageResources(this.request, this.app);
        List list = this.createActionList(validatorResources, form);
        String string = this.createMethods(list);
        stringBuffer.append(this.getJavascriptBegin(string));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValidatorAction validatorAction = (ValidatorAction)iterator.next();
            String string2 = null;
            String string3 = null;
            string3 = validatorAction.getJsFunctionName() != null && validatorAction.getJsFunctionName().length() > 0 ? validatorAction.getJsFunctionName() : validatorAction.getName();
            stringBuffer.append("    function ");
            stringBuffer.append(string3);
            stringBuffer.append(" () { \n");
            Iterator iterator2 = form.getFields().iterator();
            while (iterator2.hasNext()) {
                Field field = (Field)iterator2.next();
                if (field.isIndexed() || field.getPage() != this.page || !field.isDependency(validatorAction.getName())) continue;
                String string4 = Resources.getMessage((MessageResources)messageResources, (Locale)locale, (ValidatorAction)validatorAction, (Field)field);
                if (string4 == null) {
                    string4 = "";
                }
                string2 = this.getNextVar(string2);
                stringBuffer.append("     this.");
                stringBuffer.append(string2);
                stringBuffer.append(" = new Array(\"");
                stringBuffer.append(field.getKey());
                stringBuffer.append("\", \"");
                stringBuffer.append(string4);
                stringBuffer.append("\", ");
                stringBuffer.append("new Function (\"varName\", \"");
                Map map = field.getVars();
                Iterator iterator3 = map.keySet().iterator();
                while (iterator3.hasNext()) {
                    String string5 = (String)iterator3.next();
                    Var var = (Var)map.get(string5);
                    String string6 = var.getValue();
                    String string7 = var.getJsType();
                    if (string5.startsWith("field")) continue;
                    stringBuffer.append("this.");
                    stringBuffer.append(string5);
                    String string8 = ValidatorUtil.replace((String)string6, (String)"\\", (String)"\\\\");
                    if ("int".equalsIgnoreCase(string7)) {
                        stringBuffer.append("=");
                        stringBuffer.append(string8);
                        stringBuffer.append("; ");
                        continue;
                    }
                    if ("regexp".equalsIgnoreCase(string7)) {
                        stringBuffer.append("=/");
                        stringBuffer.append(string8);
                        stringBuffer.append("/; ");
                        continue;
                    }
                    if ("string".equalsIgnoreCase(string7)) {
                        stringBuffer.append("='");
                        stringBuffer.append(string8);
                        stringBuffer.append("'; ");
                        continue;
                    }
                    if ("mask".equalsIgnoreCase(string5)) {
                        stringBuffer.append("=/");
                        stringBuffer.append(string8);
                        stringBuffer.append("/; ");
                        continue;
                    }
                    stringBuffer.append("='");
                    stringBuffer.append(string8);
                    stringBuffer.append("'; ");
                }
                stringBuffer.append(" return this[varName];\"));\n");
            }
            stringBuffer.append("    } \n\n");
        }
        return stringBuffer.toString();
    }

    protected String createMethods(List list) {
        String string = " && ";
        StringBuffer stringBuffer = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValidatorAction validatorAction = (ValidatorAction)iterator.next();
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(validatorAction.getMethod());
            } else {
                stringBuffer.append(string);
                stringBuffer.append(validatorAction.getMethod());
            }
            stringBuffer.append("(form)");
        }
        return stringBuffer.toString();
    }

    protected List createActionList(ValidatorResources validatorResources, Form form) {
        Object object;
        Object object2;
        Object object3;
        ArrayList arrayList = new ArrayList();
        Object object4 = form.getFields().iterator();
        while (object4.hasNext()) {
            object3 = (Field)object4.next();
            object2 = object3.getDependencies().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (object == null || arrayList.contains(object)) continue;
                arrayList.add(object);
            }
        }
        object4 = new ArrayList();
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = validatorResources.getValidatorAction((String)object2);
            if (object == null) {
                throw new NullPointerException("Depends string \"" + (String)object2 + "\" was not found in validator-rules.xml.");
            }
            String string = object.getJavascript();
            if (string != null && string.length() > 0) {
                object4.add(object);
                continue;
            }
            object3.remove();
        }
        object3 = new ValidatorActionComparator();
        Collections.sort(object4, object3);
        return object4;
    }

    protected String getJavascriptBegin(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.formName.replace('/', '_');
        string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length());
        stringBuffer.append(this.getStartElement());
        if (this.xhtml && this.cdata) {
            stringBuffer.append("<![CDATA[\r\n");
        }
        if (!this.xhtml && this.htmlComment) {
            stringBuffer.append(HTML_BEGIN_COMMENT);
        }
        stringBuffer.append("\n     var bCancel = false; \n\n");
        if (this.methodName == null || this.methodName.length() == 0) {
            stringBuffer.append("    function validate");
            stringBuffer.append(string2);
        } else {
            stringBuffer.append("    function ");
            stringBuffer.append(this.methodName);
        }
        stringBuffer.append("(form) {");
        stringBuffer.append("                                                                   \n");
        stringBuffer.append("        if (bCancel) \n");
        stringBuffer.append("      return true; \n");
        stringBuffer.append("        else \n");
        if (string == null || string.length() == 0) {
            stringBuffer.append("       return true; \n");
        } else {
            stringBuffer.append("       return ");
            stringBuffer.append(string);
            stringBuffer.append("; \n");
        }
        stringBuffer.append("   } \n\n");
        return stringBuffer.toString();
    }

    protected String getJavascriptStaticMethods(ValidatorResources validatorResources) {
        StringBuffer stringBuffer = new StringBuffer("\n\n");
        Iterator iterator = validatorResources.getValidatorActions().values().iterator();
        while (iterator.hasNext()) {
            String string;
            ValidatorAction validatorAction = (ValidatorAction)iterator.next();
            if (validatorAction == null || (string = validatorAction.getJavascript()) == null || string.length() <= 0) continue;
            stringBuffer.append(string + "\n");
        }
        return stringBuffer.toString();
    }

    protected String getJavascriptEnd() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        if (!this.xhtml && this.htmlComment) {
            stringBuffer.append(HTML_END_COMMENT);
        }
        if (this.xhtml && this.cdata) {
            stringBuffer.append("]]>\r\n");
        }
        stringBuffer.append("</script>\n\n");
        return stringBuffer.toString();
    }

    private String getNextVar(String string) {
        if (string == null) {
            return "aa";
        }
        string = string.toLowerCase();
        for (int i = string.length(); i > 0; --i) {
            int n = i - 1;
            char c = string.charAt(n);
            if ((c = (char)(c + '\u0001')) <= 'z') {
                if (i == 0) {
                    return c + string.substring(n, string.length());
                }
                if (i == string.length()) {
                    return string.substring(0, n) + c;
                }
                return string.substring(0, n) + c + string.substring(n, string.length() - 1);
            }
            string = this.replaceChar(string, n, 'a');
        }
        return null;
    }

    private String replaceChar(String string, int n, char c) {
        if (n == 0) {
            return c + string.substring(n, string.length());
        }
        if (n == string.length()) {
            return string.substring(0, n) + c;
        }
        return string.substring(0, n) + c + string.substring(n, string.length() - 1);
    }

    private String getStartElement() {
        StringBuffer stringBuffer = new StringBuffer("<script type=\"text/javascript\"");
        if (!this.xhtml) {
            stringBuffer.append(" language=\"Javascript1.1\"");
        }
        if (this.src != null) {
            stringBuffer.append(" src=\"" + this.src + "\"");
        }
        stringBuffer.append("> \n");
        return stringBuffer.toString();
    }

    protected class ValidatorActionComparator
    implements Comparator {
        protected ValidatorActionComparator() {
        }

        public int compare(Object object, Object object2) {
            ValidatorAction validatorAction = (ValidatorAction)object;
            ValidatorAction validatorAction2 = (ValidatorAction)object2;
            String string = validatorAction.getDepends();
            String string2 = validatorAction2.getDepends();
            if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0)) {
                return 0;
            }
            if (string != null && string.length() > 0 && (string2 == null || string2.length() == 0)) {
                return 1;
            }
            if ((string == null || string.length() == 0) && string2 != null && string2.length() > 0) {
                return -1;
            }
            return validatorAction.getDependencies().size() - validatorAction2.getDependencies().size();
        }
    }
}

