/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.tiles.AttributeDefinition;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionAttribute;
import org.apache.struts.tiles.DefinitionNameAttribute;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DirectStringAttribute;
import org.apache.struts.tiles.TilesUtil;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.ImportSupport;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class TilesTool
extends ImportSupport
implements ViewTool {
    static final String PAGE_SCOPE = "page";
    static final String REQUEST_SCOPE = "request";
    static final String SESSION_SCOPE = "session";
    static final String APPLICATION_SCOPE = "application";
    protected Context velocityContext;
    protected Stack contextStack;

    public void init(Object object) {
        if (!(object instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext viewContext = (ViewContext)object;
        this.velocityContext = viewContext.getVelocityContext();
        this.request = viewContext.getRequest();
        this.response = viewContext.getResponse();
        this.application = viewContext.getServletContext();
    }

    public String get(Object object) {
        try {
            Object object2 = this.getCurrentContext().getAttribute(object.toString());
            if (object2 != null) {
                return this.processObjectValue(object2);
            }
            return this.processAsDefinitionOrURL(object.toString());
        }
        catch (Exception exception) {
            Velocity.error((Object)("TilesTool: Exeption while rendering Tile " + object + ": " + exception.getMessage()));
            return null;
        }
    }

    public Object getAttribute(String string) {
        Object object = this.getCurrentContext().getAttribute(string);
        if (object == null) {
            Velocity.warn((Object)("TilesTool: Tile attribute '" + string + "' was not found in context."));
        }
        return object;
    }

    public void importAttribute(String string) {
        this.importAttribute(string, PAGE_SCOPE);
    }

    public void importAttribute(String string, String string2) {
        Object object = this.getCurrentContext().getAttribute(string);
        if (object == null) {
            Velocity.warn((Object)("TilesTool: Tile attribute '" + string + "' was not found in context."));
        }
        if (string2.equals(PAGE_SCOPE)) {
            this.velocityContext.put(string, object);
        } else if (string2.equals(REQUEST_SCOPE)) {
            this.request.setAttribute(string, object);
        } else if (string2.equals(SESSION_SCOPE)) {
            this.request.getSession().setAttribute(string, object);
        } else if (string2.equals(APPLICATION_SCOPE)) {
            this.application.setAttribute(string, object);
        }
    }

    public void importAttributes() {
        this.importAttributes(PAGE_SCOPE);
    }

    public void importAttributes(String string) {
        block5: {
            Iterator iterator;
            ComponentContext componentContext;
            block7: {
                block6: {
                    block4: {
                        componentContext = this.getCurrentContext();
                        iterator = componentContext.getAttributeNames();
                        if (!string.equals(PAGE_SCOPE)) break block4;
                        while (iterator.hasNext()) {
                            String string2 = (String)iterator.next();
                            this.velocityContext.put(string2, componentContext.getAttribute(string2));
                        }
                        break block5;
                    }
                    if (!string.equals(REQUEST_SCOPE)) break block6;
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        this.request.setAttribute(string3, componentContext.getAttribute(string3));
                    }
                    break block5;
                }
                if (!string.equals(SESSION_SCOPE)) break block7;
                HttpSession httpSession = this.request.getSession();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    httpSession.setAttribute(string4, componentContext.getAttribute(string4));
                }
                break block5;
            }
            if (!string.equals(APPLICATION_SCOPE)) break block5;
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                this.application.setAttribute(string5, componentContext.getAttribute(string5));
            }
        }
    }

    protected String processObjectValue(Object object) throws Exception {
        if (object instanceof AttributeDefinition) {
            return this.processTypedAttribute((AttributeDefinition)object);
        }
        if (object instanceof ComponentDefinition) {
            return this.processDefinition((ComponentDefinition)object);
        }
        return this.processAsDefinitionOrURL(object.toString());
    }

    protected String processTypedAttribute(AttributeDefinition attributeDefinition) throws Exception {
        if (attributeDefinition instanceof DirectStringAttribute) {
            return (String)attributeDefinition.getValue();
        }
        if (attributeDefinition instanceof DefinitionAttribute) {
            return this.processDefinition((ComponentDefinition)attributeDefinition.getValue());
        }
        if (attributeDefinition instanceof DefinitionNameAttribute) {
            return this.processAsDefinitionOrURL((String)attributeDefinition.getValue());
        }
        return this.doInsert((String)attributeDefinition.getValue(), null, null);
    }

    protected String processAsDefinitionOrURL(String string) throws Exception {
        try {
            ComponentDefinition componentDefinition = TilesUtil.getDefinition((String)string, (ServletRequest)this.request, (ServletContext)this.application);
            if (componentDefinition != null) {
                return this.processDefinition(componentDefinition);
            }
        }
        catch (DefinitionsFactoryException definitionsFactoryException) {
            // empty catch block
        }
        return this.processUrl(string);
    }

    protected String processDefinition(ComponentDefinition componentDefinition) throws Exception {
        Controller controller = null;
        try {
            controller = componentDefinition.getOrCreateController();
            String string = componentDefinition.getRole();
            String string2 = componentDefinition.getTemplate();
            return this.doInsert(componentDefinition.getAttributes(), string2, string, controller);
        }
        catch (InstantiationException instantiationException) {
            throw new Exception(instantiationException.getMessage());
        }
    }

    protected String processUrl(String string) throws Exception {
        return this.doInsert(string, null, null);
    }

    protected String doInsert(String string, String string2, Controller controller) throws Exception {
        if (string2 != null && !this.request.isUserInRole(string2)) {
            return null;
        }
        ComponentContext componentContext = new ComponentContext();
        return this.doInsert(componentContext, string, string2, controller);
    }

    protected String doInsert(Map map, String string, String string2, Controller controller) throws Exception {
        if (string2 != null && !this.request.isUserInRole(string2)) {
            return null;
        }
        ComponentContext componentContext = new ComponentContext(map);
        return this.doInsert(componentContext, string, string2, controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doInsert(ComponentContext componentContext, String string, String string2, Controller controller) throws Exception {
        this.pushTilesContext();
        try {
            ComponentContext.setContext((ComponentContext)componentContext, (ServletRequest)this.request);
            if (controller != null) {
                controller.perform(componentContext, this.request, this.response, this.application);
            }
            String string3 = this.acquireString(string);
            return string3;
        }
        finally {
            this.popTilesContext();
        }
    }

    protected ComponentContext getCurrentContext() {
        return ComponentContext.getContext((ServletRequest)this.request);
    }

    protected void pushTilesContext() {
        if (this.contextStack == null) {
            this.contextStack = new Stack();
        }
        this.contextStack.push(this.getCurrentContext());
    }

    protected void popTilesContext() {
        ComponentContext componentContext = (ComponentContext)this.contextStack.pop();
        ComponentContext.setContext((ComponentContext)componentContext, (ServletRequest)this.request);
    }
}

