/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.SecurePlugInInterface;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.SecureActionConfig;
import org.apache.velocity.tools.struts.StrutsUtils;
import org.apache.velocity.tools.view.tools.LinkTool;

public class SecureLinkTool
extends LinkTool {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String STD_HTTP_PORT = "80";
    private static final String STD_HTTPS_PORT = "443";

    public SecureLinkTool setAction(String string) {
        String string2 = StrutsUtils.getActionMappingURL(this.application, this.request, string);
        return (SecureLinkTool)this.copyWith(this.computeURL(this.request, this.application, string2));
    }

    public SecureLinkTool setForward(String string) {
        String string2 = StrutsUtils.getForwardURL(this.request, this.application, string);
        if (string2 == null) {
            return null;
        }
        return (SecureLinkTool)this.copyWith(string2);
    }

    public String computeURL(HttpServletRequest httpServletRequest, ServletContext servletContext, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = httpServletRequest.getContextPath();
        SecurePlugInInterface securePlugInInterface = (SecurePlugInInterface)servletContext.getAttribute("org.apache.struts.action.SecurePlugIn-Instance");
        if (securePlugInInterface.getSslExtEnable() && stringBuffer.toString().startsWith(string2)) {
            String string3 = httpServletRequest.getScheme();
            String string4 = String.valueOf(httpServletRequest.getServerPort());
            String string5 = stringBuffer.toString().substring(string2.length());
            SecureActionConfig secureActionConfig = SecureLinkTool.getActionConfig(httpServletRequest, servletContext, string5);
            if (secureActionConfig != null && !"any".equalsIgnoreCase(secureActionConfig.getSecure())) {
                String string6;
                String string7 = Boolean.valueOf(secureActionConfig.getSecure()) != false ? HTTPS : HTTP;
                String string8 = string6 = Boolean.valueOf(secureActionConfig.getSecure()) != false ? securePlugInInterface.getHttpsPort() : securePlugInInterface.getHttpPort();
                if (!string7.equals(string3) || !string6.equals(string4)) {
                    stringBuffer.insert(0, (Object)SecureLinkTool.startNewUrlString(httpServletRequest, string7, string6));
                    if (securePlugInInterface.getSslExtAddSession() && stringBuffer.toString().indexOf(";jsessionid=") < 0) {
                        stringBuffer = new StringBuffer(this.toEncoded(stringBuffer.toString(), httpServletRequest.getSession().getId()));
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    private static SecureActionConfig getActionConfig(HttpServletRequest httpServletRequest, ServletContext servletContext, String string) {
        ModuleConfig moduleConfig = StrutsUtils.selectModule(string, servletContext);
        string = string.substring(moduleConfig.getPrefix().length());
        SecurePlugInInterface securePlugInInterface = (SecurePlugInInterface)servletContext.getAttribute("org.apache.struts.action.SecurePlugIn-Instance");
        Iterator iterator = securePlugInInterface.getServletMappings().iterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            int n3;
            String string2 = (String)iterator.next();
            int n4 = n3 = string2 != null ? string2.indexOf(42) : -1;
            if (n3 == -1) continue;
            String string3 = string2.substring(0, n3);
            String string4 = string2.substring(n3 + 1);
            int n5 = string.indexOf(";jsessionid=");
            if (n5 >= 0) {
                string = string.substring(0, n5);
            }
            if ((n2 = string.indexOf("?")) >= 0) {
                string = string.substring(0, n2);
            }
            if ((n = string.indexOf("#")) >= 0) {
                string = string.substring(0, n);
            }
            if (!string.startsWith(string3) || !string.endsWith(string4)) continue;
            string = string.substring(string3.length());
            if (!(string = string.substring(0, string.length() - string4.length())).startsWith("/")) {
                string = "/" + string;
            }
            SecureActionConfig secureActionConfig = (SecureActionConfig)moduleConfig.findActionConfig(string);
            return secureActionConfig;
        }
        return null;
    }

    private static StringBuffer startNewUrlString(HttpServletRequest httpServletRequest, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = httpServletRequest.getServerName();
        stringBuffer.append(string).append("://").append(string3);
        if (HTTP.equals(string) && !STD_HTTP_PORT.equals(string2) || HTTPS.equals(string) && !STD_HTTPS_PORT.equals(string2)) {
            stringBuffer.append(":").append(string2);
        }
        return stringBuffer;
    }

    public String toEncoded(String string, String string2) {
        StringBuffer stringBuffer;
        int n;
        if (string == null || string2 == null) {
            return string;
        }
        String string3 = string;
        String string4 = "";
        String string5 = "";
        int n2 = string.indexOf(35);
        if (n2 >= 0) {
            string3 = string.substring(0, n2);
            string5 = string.substring(n2);
        }
        if ((n = string3.indexOf(63)) >= 0) {
            string4 = string3.substring(n);
            string3 = string3.substring(0, n);
        }
        if ((stringBuffer = new StringBuffer(string3)).length() > 0) {
            stringBuffer.append(";jsessionid=");
            stringBuffer.append(string2);
        }
        stringBuffer.append(string4);
        stringBuffer.append(string5);
        return stringBuffer.toString();
    }
}

