/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.MessageResources;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.tools.struts.StrutsUtils;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public abstract class MessageResourcesTool
implements ViewTool {
    protected ServletContext application;
    protected HttpServletRequest request;
    protected Locale locale;
    protected MessageResources resources;

    public void init(Object object) {
        if (!(object instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext viewContext = (ViewContext)object;
        this.request = viewContext.getRequest();
        this.application = viewContext.getServletContext();
        this.resources = StrutsUtils.getMessageResources(this.request, this.application);
        this.locale = StrutsUtils.getLocale(this.request, this.request.getSession(false));
    }

    protected MessageResources getResources(String string) {
        if (string == null) {
            if (this.resources == null) {
                Velocity.error((Object)"MessageResourcesTool: Message resources are not available.");
            }
            return this.resources;
        }
        MessageResources messageResources = StrutsUtils.getMessageResources(this.request, this.application, string);
        if (messageResources == null) {
            Velocity.error((Object)("MessageResourcesTool: MessageResources bundle '" + string + "' is not available."));
        }
        return messageResources;
    }
}

