/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.text.NumberFormat;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class CustomNumberEditor
extends PropertyEditorSupport {
    private final Class numberClass;
    private final NumberFormat numberFormat;
    private final boolean allowEmpty;
    static /* synthetic */ Class class$java$lang$Number;

    public CustomNumberEditor(Class numberClass, boolean allowEmpty) throws IllegalArgumentException {
        if (numberClass == null || !(class$java$lang$Number == null ? (class$java$lang$Number = CustomNumberEditor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(numberClass)) {
            throw new IllegalArgumentException("Property class must be a subclass of Number");
        }
        this.numberClass = numberClass;
        this.numberFormat = null;
        this.allowEmpty = allowEmpty;
    }

    public CustomNumberEditor(Class numberClass, NumberFormat numberFormat, boolean allowEmpty) throws IllegalArgumentException {
        if (numberClass == null || !(class$java$lang$Number == null ? (class$java$lang$Number = CustomNumberEditor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(numberClass)) {
            throw new IllegalArgumentException("Property class must be a subclass of Number");
        }
        this.numberClass = numberClass;
        this.numberFormat = numberFormat;
        this.allowEmpty = allowEmpty;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText(text)) {
            this.setValue(null);
        } else if (this.numberFormat != null) {
            this.setValue(NumberUtils.parseNumber(text, this.numberClass, this.numberFormat));
        } else {
            this.setValue(NumberUtils.parseNumber(text, this.numberClass));
        }
    }

    public String getAsText() {
        Object value = this.getValue();
        if (value != null) {
            if (this.numberFormat != null) {
                return this.numberFormat.format(value);
            }
            return value.toString();
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

