/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.profiler.rules.RuleCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.CountryCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.GroupCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.GroupRoleUserCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.HardCodedResolver;
import org.apache.jetspeed.profiler.rules.impl.LanguageCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.MediatypeCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.NavigationCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.PathResolver;
import org.apache.jetspeed.profiler.rules.impl.PathSessionResolver;
import org.apache.jetspeed.profiler.rules.impl.RequestSessionResolver;
import org.apache.jetspeed.profiler.rules.impl.RoleCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.StandardResolver;
import org.apache.jetspeed.profiler.rules.impl.UserAttributeResolver;
import org.apache.jetspeed.profiler.rules.impl.UserCriterionResolver;
import org.apache.jetspeed.request.RequestContext;

public abstract class AbstractProfilingRule
implements ProfilingRule {
    protected Collection criteria = new Vector();
    protected String id;
    protected String title;
    protected String ojbConcreteClass;
    static Map locators = new HashMap();
    static Map resolvers = new HashMap();

    protected ProfileLocator getLocatorFromCache(String key) {
        return (ProfileLocator)locators.get(key);
    }

    protected void addLocatorToCache(String key, ProfileLocator locator) {
        locators.put(key, locator);
    }

    public RuleCriterionResolver getResolver(String name) {
        return (RuleCriterionResolver)resolvers.get(name);
    }

    public RuleCriterionResolver getDefaultResolver() {
        return (RuleCriterionResolver)resolvers.get("request");
    }

    public abstract ProfileLocator apply(RequestContext var1, Profiler var2);

    public Collection getRuleCriteria() {
        return this.criteria;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getClassname() {
        return this.ojbConcreteClass;
    }

    public void setClassname(String classname) {
        this.ojbConcreteClass = classname;
    }

    public String toString() {
        if (this.id != null) {
            return this.id;
        }
        if (this.title != null) {
            return this.title;
        }
        return this.getClass().toString();
    }

    static {
        resolvers.put("request", new StandardResolver());
        resolvers.put("request.session", new RequestSessionResolver());
        resolvers.put("path", new PathResolver());
        resolvers.put("path.session", new PathSessionResolver());
        resolvers.put("hard.coded", new HardCodedResolver());
        resolvers.put("user", new UserCriterionResolver());
        resolvers.put("role", new RoleCriterionResolver());
        resolvers.put("group", new GroupCriterionResolver());
        resolvers.put("mediatype", new MediatypeCriterionResolver());
        resolvers.put("language", new LanguageCriterionResolver());
        resolvers.put("country", new CountryCriterionResolver());
        resolvers.put("group.role.user", new GroupRoleUserCriterionResolver());
        resolvers.put("user.attribute", new UserAttributeResolver());
        resolvers.put("navigation", new NavigationCriterionResolver());
    }
}

