/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.ProfiledPageContext;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.ProfilerException;
import org.apache.jetspeed.profiler.rules.PrincipalRule;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.profiler.rules.impl.PrincipalRuleImpl;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;

public class JetspeedProfilerImpl
extends InitablePersistenceBrokerDaoSupport
implements Profiler {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$profiler$impl$JetspeedProfilerImpl == null ? (class$org$apache$jetspeed$profiler$impl$JetspeedProfilerImpl = JetspeedProfilerImpl.class$("org.apache.jetspeed.profiler.impl.JetspeedProfilerImpl")) : class$org$apache$jetspeed$profiler$impl$JetspeedProfilerImpl));
    public static final Principal DEFAULT_RULE_PRINCIPAL = new UserPrincipalImpl("*");
    private Class locatorClass = class$org$apache$jetspeed$profiler$impl$JetspeedProfileLocator == null ? (class$org$apache$jetspeed$profiler$impl$JetspeedProfileLocator = JetspeedProfilerImpl.class$("org.apache.jetspeed.profiler.impl.JetspeedProfileLocator")) : class$org$apache$jetspeed$profiler$impl$JetspeedProfileLocator;
    private Class profiledPageContextClass = class$org$apache$jetspeed$profiler$impl$JetspeedProfiledPageContext == null ? (class$org$apache$jetspeed$profiler$impl$JetspeedProfiledPageContext = JetspeedProfilerImpl.class$("org.apache.jetspeed.profiler.impl.JetspeedProfiledPageContext")) : class$org$apache$jetspeed$profiler$impl$JetspeedProfiledPageContext;
    private Class principalRuleClass = class$org$apache$jetspeed$profiler$rules$impl$PrincipalRuleImpl == null ? (class$org$apache$jetspeed$profiler$rules$impl$PrincipalRuleImpl = JetspeedProfilerImpl.class$("org.apache.jetspeed.profiler.rules.impl.PrincipalRuleImpl")) : class$org$apache$jetspeed$profiler$rules$impl$PrincipalRuleImpl;
    private Class profilingRuleClass = class$org$apache$jetspeed$profiler$rules$impl$AbstractProfilingRule == null ? (class$org$apache$jetspeed$profiler$rules$impl$AbstractProfilingRule = JetspeedProfilerImpl.class$("org.apache.jetspeed.profiler.rules.impl.AbstractProfilingRule")) : class$org$apache$jetspeed$profiler$rules$impl$AbstractProfilingRule;
    private String defaultRule = "j1";
    private Map principalRules = new HashMap();
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$impl$JetspeedProfilerImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$impl$JetspeedProfileLocator;
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$impl$JetspeedProfiledPageContext;
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$rules$impl$PrincipalRuleImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$rules$impl$AbstractProfilingRule;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;

    public JetspeedProfilerImpl(String repositoryPath) {
        super(repositoryPath);
    }

    public JetspeedProfilerImpl(String repositoryPath, String defaultRule) throws ClassNotFoundException {
        this(repositoryPath);
        this.defaultRule = defaultRule;
    }

    public JetspeedProfilerImpl(String repositoryPath, String defaultRule, Properties properties) throws ClassNotFoundException {
        this(repositoryPath, defaultRule);
        this.initModelClasses(properties);
    }

    private void initModelClasses(Properties properties) throws ClassNotFoundException {
        String modelName = "";
        modelName = properties.getProperty("locator.impl");
        if (modelName != null) {
            this.locatorClass = Class.forName(modelName);
        }
        if ((modelName = properties.getProperty("profiledPageContext.impl")) != null) {
            this.profiledPageContextClass = Class.forName(modelName);
        }
        if ((modelName = properties.getProperty("principalRule.impl")) != null) {
            this.principalRuleClass = Class.forName(modelName);
        }
        if ((modelName = properties.getProperty("profilingRule.impl")) != null) {
            this.profilingRuleClass = Class.forName(modelName);
        }
    }

    public ProfileLocator getProfile(RequestContext context, String locatorName) throws ProfilerException {
        Subject subject = context.getSubject();
        if (subject == null) {
            String msg = "Invalid (null) Subject in request pipeline";
            log.error((Object)msg);
            throw new ProfilerException(msg);
        }
        Principal principal = SecurityHelper.getBestPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = JetspeedProfilerImpl.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal));
        if (principal == null) {
            String msg = "Could not find a principle for subject in request pipeline";
            log.error((Object)msg);
            throw new ProfilerException(msg);
        }
        ProfilingRule rule = this.getRuleForPrincipal(principal, locatorName);
        if (null == rule) {
            log.warn((Object)("Could not find profiling rule for principal: " + principal));
            rule = this.getDefaultRule();
        }
        if (null == rule) {
            String msg = "Couldn't find any profiling rules including default rule for principal " + principal;
            log.error((Object)msg);
            throw new ProfilerException(msg);
        }
        return rule.apply(context, (Profiler)this);
    }

    public ProfileLocator getDefaultProfile(RequestContext context, String locatorName) throws ProfilerException {
        ProfilingRule rule = this.getRuleForPrincipal(DEFAULT_RULE_PRINCIPAL, locatorName);
        if (null == rule) {
            log.warn((Object)("Could not find profiling rule for principal: " + DEFAULT_RULE_PRINCIPAL));
            rule = this.getDefaultRule();
        }
        if (null == rule) {
            String msg = "Couldn't find any profiling rules including default rule for principal " + DEFAULT_RULE_PRINCIPAL;
            log.error((Object)msg);
            throw new ProfilerException(msg);
        }
        return rule.apply(context, (Profiler)this);
    }

    public ProfileLocator getProfile(RequestContext context, ProfilingRule rule) throws ProfilerException {
        return rule.apply(context, (Profiler)this);
    }

    public ProfileLocator createLocator(RequestContext context) {
        try {
            ProfileLocator locator = (ProfileLocator)this.locatorClass.newInstance();
            locator.init((Profiler)this, context.getPath());
            return locator;
        }
        catch (Exception e) {
            log.error((Object)("Failed to create locator for " + this.locatorClass));
            return null;
        }
    }

    public ProfiledPageContext createProfiledPageContext(Map locators) {
        try {
            ProfiledPageContext pageContext = (ProfiledPageContext)this.profiledPageContextClass.newInstance();
            pageContext.init((Profiler)this, locators);
            return pageContext;
        }
        catch (Exception e) {
            log.error((Object)("Failed to create profiled page context for " + this.profiledPageContextClass));
            return null;
        }
    }

    public ProfilingRule getRuleForPrincipal(Principal principal, String locatorName) {
        ProfilingRule rule = null;
        PrincipalRule pr = this.lookupPrincipalRule(principal.getName(), locatorName);
        if (pr == null) {
            rule = this.getRule(locatorName);
            if (rule == null) {
                rule = this.getDefaultRule();
            }
        } else {
            rule = pr.getProfilingRule();
        }
        return rule;
    }

    public void setRuleForPrincipal(Principal principal, ProfilingRule rule, String locatorName) {
        Criteria c = new Criteria();
        c.addEqualTo("principalName", (Object)principal.getName());
        c.addEqualTo("locatorName", (Object)locatorName);
        PrincipalRule pr = (PrincipalRule)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)this.principalRuleClass, (Criteria)c));
        if (pr == null) {
            pr = new PrincipalRuleImpl();
            pr.setPrincipalName(principal.getName());
            pr.setLocatorName(locatorName);
            pr.setProfilingRule(rule);
        }
        pr.setProfilingRule(rule);
        this.getPersistenceBrokerTemplate().store((Object)pr);
        this.principalRules.put(this.makePrincipalRuleKey(principal.getName(), locatorName), pr);
    }

    private String makePrincipalRuleKey(String principal, String locator) {
        return principal + ":" + locator;
    }

    private PrincipalRule lookupPrincipalRule(String principal, String locatorName) {
        PrincipalRule pr = (PrincipalRule)this.principalRules.get(this.makePrincipalRuleKey(principal, locatorName));
        if (pr != null) {
            return pr;
        }
        Criteria c = new Criteria();
        c.addEqualTo("principalName", (Object)principal);
        c.addEqualTo("locatorName", (Object)locatorName);
        pr = (PrincipalRule)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)this.principalRuleClass, (Criteria)c));
        this.principalRules.put(this.makePrincipalRuleKey(principal, locatorName), pr);
        return pr;
    }

    public ProfilingRule getDefaultRule() {
        return this.getRule(this.defaultRule);
    }

    public Collection getRules() {
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)this.profilingRuleClass, (Criteria)new Criteria()));
    }

    public ProfilingRule getRule(String id) {
        Criteria c = new Criteria();
        c.addEqualTo("id", (Object)id);
        return (ProfilingRule)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery((Class)this.profilingRuleClass, (Criteria)c));
    }

    public String[] getLocatorNamesForPrincipal(Principal principal) {
        Criteria c = new Criteria();
        c.addEqualTo("principalName", (Object)principal.getName());
        Collection result = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)this.principalRuleClass, (Criteria)c));
        if (result.size() == 0) {
            return new String[0];
        }
        String[] names = new String[result.size()];
        Iterator it = result.iterator();
        int ix = 0;
        while (it.hasNext()) {
            PrincipalRule pr = (PrincipalRule)it.next();
            names[ix] = pr.getLocatorName();
            ++ix;
        }
        return names;
    }

    public Collection getRulesForPrincipal(Principal principal) {
        Criteria c = new Criteria();
        c.addEqualTo("principalName", (Object)principal.getName());
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)this.principalRuleClass, (Criteria)c));
    }

    public Map getProfileLocators(RequestContext context, Principal principal) throws ProfilerException {
        HashMap<String, ProfileLocator> locators = new HashMap<String, ProfileLocator>();
        Collection rules = this.getRulesForPrincipal(principal);
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            PrincipalRule pr = (PrincipalRule)it.next();
            locators.put(pr.getLocatorName(), this.getProfile(context, pr.getLocatorName()));
        }
        return locators;
    }

    public Map getDefaultProfileLocators(RequestContext context) throws ProfilerException {
        HashMap<String, ProfileLocator> locators = new HashMap<String, ProfileLocator>();
        Collection rules = this.getRulesForPrincipal(DEFAULT_RULE_PRINCIPAL);
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            PrincipalRule pr = (PrincipalRule)it.next();
            locators.put(pr.getLocatorName(), this.getDefaultProfile(context, pr.getLocatorName()));
        }
        return locators;
    }

    public void storeProfilingRule(ProfilingRule rule) throws ProfilerException {
        this.getPersistenceBrokerTemplate().store((Object)rule);
    }

    public void deleteProfilingRule(ProfilingRule rule) throws ProfilerException {
        this.getPersistenceBrokerTemplate().delete((Object)rule);
    }

    public void storePrincipalRule(PrincipalRule rule) throws ProfilerException {
        this.getPersistenceBrokerTemplate().store((Object)rule);
    }

    public void deletePrincipalRule(PrincipalRule rule) throws ProfilerException {
        this.getPersistenceBrokerTemplate().delete((Object)rule);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

