/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.components.persistence.store.Filter;
import org.apache.jetspeed.components.persistence.store.LockFailedException;
import org.apache.jetspeed.components.persistence.store.PersistenceStore;
import org.apache.jetspeed.components.persistence.store.Transaction;
import org.apache.jetspeed.profiler.ProfileLocator;
import org.apache.jetspeed.profiler.ProfiledPageContext;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.profiler.ProfilerException;
import org.apache.jetspeed.profiler.rules.PrincipalRule;
import org.apache.jetspeed.profiler.rules.ProfilingRule;
import org.apache.jetspeed.profiler.rules.impl.PrincipalRuleImpl;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityHelper;

public class JetspeedProfiler
implements Profiler {
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$profiler$impl$JetspeedProfiler == null ? (class$org$apache$jetspeed$profiler$impl$JetspeedProfiler = JetspeedProfiler.class$("org.apache.jetspeed.profiler.impl.JetspeedProfiler")) : class$org$apache$jetspeed$profiler$impl$JetspeedProfiler));
    private Class locatorClass = class$org$apache$jetspeed$profiler$impl$JetspeedProfileLocator == null ? (class$org$apache$jetspeed$profiler$impl$JetspeedProfileLocator = JetspeedProfiler.class$("org.apache.jetspeed.profiler.impl.JetspeedProfileLocator")) : class$org$apache$jetspeed$profiler$impl$JetspeedProfileLocator;
    private Class profiledPageContextClass = class$org$apache$jetspeed$profiler$impl$JetspeedProfiledPageContext == null ? (class$org$apache$jetspeed$profiler$impl$JetspeedProfiledPageContext = JetspeedProfiler.class$("org.apache.jetspeed.profiler.impl.JetspeedProfiledPageContext")) : class$org$apache$jetspeed$profiler$impl$JetspeedProfiledPageContext;
    private Class principalRuleClass = class$org$apache$jetspeed$profiler$rules$impl$PrincipalRuleImpl == null ? (class$org$apache$jetspeed$profiler$rules$impl$PrincipalRuleImpl = JetspeedProfiler.class$("org.apache.jetspeed.profiler.rules.impl.PrincipalRuleImpl")) : class$org$apache$jetspeed$profiler$rules$impl$PrincipalRuleImpl;
    private Class profilingRuleClass = class$org$apache$jetspeed$profiler$rules$impl$AbstractProfilingRule == null ? (class$org$apache$jetspeed$profiler$rules$impl$AbstractProfilingRule = JetspeedProfiler.class$("org.apache.jetspeed.profiler.rules.impl.AbstractProfilingRule")) : class$org$apache$jetspeed$profiler$rules$impl$AbstractProfilingRule;
    private String defaultRule = "j1";
    private String anonymousUser = "guest";
    PersistenceStore persistentStore;
    private Map principalRules = new HashMap();
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$impl$JetspeedProfiler;
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$impl$JetspeedProfileLocator;
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$impl$JetspeedProfiledPageContext;
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$rules$impl$PrincipalRuleImpl;
    static /* synthetic */ Class class$org$apache$jetspeed$profiler$rules$impl$AbstractProfilingRule;
    static /* synthetic */ Class class$org$apache$jetspeed$security$UserPrincipal;

    public JetspeedProfiler(PersistenceStore persistentStore) {
        this.persistentStore = persistentStore;
    }

    public JetspeedProfiler(PersistenceStore persistentStore, Properties properties) throws ClassNotFoundException {
        this(persistentStore);
        this.defaultRule = properties.getProperty("defaultRule", "j1");
        this.anonymousUser = properties.getProperty("anonymousUser", "guest");
        this.initModelClasses(properties);
    }

    private void initModelClasses(Properties properties) throws ClassNotFoundException {
        String modelName = "";
        modelName = properties.getProperty("locator.impl");
        if (modelName != null) {
            this.locatorClass = Class.forName(modelName);
        }
        if ((modelName = properties.getProperty("profiledPageContext.impl")) != null) {
            this.profiledPageContextClass = Class.forName(modelName);
        }
        if ((modelName = properties.getProperty("principalRule.impl")) != null) {
            this.principalRuleClass = Class.forName(modelName);
        }
        if ((modelName = properties.getProperty("profilingRule.impl")) != null) {
            this.profilingRuleClass = Class.forName(modelName);
        }
    }

    public ProfileLocator getProfile(RequestContext context, String locatorName) throws ProfilerException {
        Subject subject = context.getSubject();
        if (subject == null) {
            String msg = "Invalid (null) Subject in request pipeline";
            log.error((Object)msg);
            throw new ProfilerException(msg);
        }
        Principal principal = SecurityHelper.getBestPrincipal((Subject)subject, (Class)(class$org$apache$jetspeed$security$UserPrincipal == null ? (class$org$apache$jetspeed$security$UserPrincipal = JetspeedProfiler.class$("org.apache.jetspeed.security.UserPrincipal")) : class$org$apache$jetspeed$security$UserPrincipal));
        if (principal == null) {
            String msg = "Could not find a principle for subject in request pipeline";
            log.error((Object)msg);
            throw new ProfilerException(msg);
        }
        ProfilingRule rule = this.getRuleForPrincipal(principal, locatorName);
        if (null == rule) {
            log.warn((Object)("Could not find profiling rule for principal: " + principal));
            rule = this.getDefaultRule();
        }
        if (null == rule) {
            String msg = "Couldn't find any profiling rules including default rule for principal " + principal;
            log.error((Object)msg);
            throw new ProfilerException(msg);
        }
        return rule.apply(context, (Profiler)this);
    }

    public ProfileLocator getProfile(RequestContext context, ProfilingRule rule) {
        return rule.apply(context, (Profiler)this);
    }

    public ProfilingRule getDefaultRule() {
        return this.lookupProfilingRule(this.defaultRule);
    }

    public ProfilingRule getRuleForPrincipal(Principal principal, String locatorName) {
        PrincipalRule pr = this.lookupPrincipalRule(principal.getName(), locatorName);
        if (pr == null) {
            return this.getDefaultRule();
        }
        return pr.getProfilingRule();
    }

    public void setRuleForPrincipal(Principal principal, ProfilingRule rule, String locatorName) {
        Transaction tx = this.persistentStore.getTransaction();
        tx.begin();
        Filter filter = this.persistentStore.newFilter();
        filter.addEqualTo("principalName", (Object)principal);
        filter.addEqualTo("locatorName", (Object)locatorName);
        Object query = this.persistentStore.newQuery(this.principalRuleClass, filter);
        PrincipalRule pr = (PrincipalRule)this.persistentStore.getObjectByQuery(query);
        if (pr == null) {
            pr = new PrincipalRuleImpl();
            pr.setPrincipalName(principal.getName());
            pr.setLocatorName(locatorName);
            pr.setProfilingRule(rule);
        }
        try {
            pr.setProfilingRule(rule);
            this.persistentStore.lockForWrite((Object)pr);
        }
        catch (LockFailedException e) {
            tx.rollback();
            e.printStackTrace();
        }
        this.persistentStore.getTransaction().commit();
        this.principalRules.put(this.makePrincipalRuleKey(principal.getName(), locatorName), pr);
    }

    private String makePrincipalRuleKey(String principal, String locator) {
        return principal + ":" + locator;
    }

    private PrincipalRule lookupPrincipalRule(String principal, String locatorName) {
        PrincipalRule pr = (PrincipalRule)this.principalRules.get(this.makePrincipalRuleKey(principal, locatorName));
        if (pr != null) {
            return pr;
        }
        Filter filter = this.persistentStore.newFilter();
        filter.addEqualTo("principalName", (Object)principal);
        filter.addEqualTo("locatorName", (Object)locatorName);
        Object query = this.persistentStore.newQuery(this.principalRuleClass, filter);
        pr = (PrincipalRule)this.persistentStore.getObjectByQuery(query);
        this.principalRules.put(this.makePrincipalRuleKey(principal, locatorName), pr);
        return pr;
    }

    private ProfilingRule lookupProfilingRule(String ruleid) {
        Filter filter = this.persistentStore.newFilter();
        Object query = this.persistentStore.newQuery(this.profilingRuleClass, filter);
        ProfilingRule rule = (ProfilingRule)this.persistentStore.getObjectByQuery(query);
        return rule;
    }

    public ProfileLocator createLocator(RequestContext context) {
        try {
            ProfileLocator locator = (ProfileLocator)this.locatorClass.newInstance();
            locator.init((Profiler)this, context.getPath());
            return locator;
        }
        catch (Exception e) {
            log.error((Object)("Failed to create locator for " + this.locatorClass));
            return null;
        }
    }

    public ProfiledPageContext createProfiledPageContext(Map locators) {
        try {
            ProfiledPageContext pageContext = (ProfiledPageContext)this.profiledPageContextClass.newInstance();
            pageContext.init((Profiler)this, locators);
            return pageContext;
        }
        catch (Exception e) {
            log.error((Object)("Failed to create profiled page context for " + this.profiledPageContextClass));
            return null;
        }
    }

    public Collection getRules() {
        return this.persistentStore.getExtent(this.profilingRuleClass);
    }

    public ProfilingRule getRule(String id) {
        Filter filter = this.persistentStore.newFilter();
        filter.addEqualTo("id", (Object)id);
        Object query = this.persistentStore.newQuery(this.profilingRuleClass, filter);
        return (ProfilingRule)this.persistentStore.getObjectByQuery(query);
    }

    public String getAnonymousUser() {
        return this.anonymousUser;
    }

    public String[] getLocatorNamesForPrincipal(Principal principal) {
        Filter filter = this.persistentStore.newFilter();
        filter.addEqualTo("principalName", (Object)principal.getName());
        Object query = this.persistentStore.newQuery(this.principalRuleClass, filter);
        Collection result = this.persistentStore.getCollectionByQuery(query);
        if (result.size() == 0) {
            return new String[0];
        }
        String[] names = new String[result.size()];
        Iterator it = result.iterator();
        int ix = 0;
        while (it.hasNext()) {
            PrincipalRule pr = (PrincipalRule)it.next();
            names[ix] = pr.getLocatorName();
            ++ix;
        }
        return names;
    }

    public Collection getRulesForPrincipal(Principal principal) {
        Filter filter = this.persistentStore.newFilter();
        filter.addEqualTo("principalName", (Object)principal.getName());
        Object query = this.persistentStore.newQuery(this.principalRuleClass, filter);
        Collection result = this.persistentStore.getCollectionByQuery(query);
        return result;
    }

    public Map getProfileLocators(RequestContext context, Principal principal) throws ProfilerException {
        HashMap<String, ProfileLocator> locators = new HashMap<String, ProfileLocator>();
        Iterator it = this.getRulesForPrincipal(principal).iterator();
        while (it.hasNext()) {
            PrincipalRule pr = (PrincipalRule)it.next();
            locators.put(pr.getLocatorName(), this.getProfile(context, pr.getLocatorName()));
        }
        return locators;
    }

    public void storeProfilingRule(ProfilingRule rule) throws ProfilerException {
        try {
            Transaction tx = this.persistentStore.getTransaction();
            tx.begin();
            this.persistentStore.makePersistent((Object)rule);
            this.persistentStore.lockForWrite((Object)rule);
            tx.commit();
        }
        catch (Exception e) {
            throw new ProfilerException("failed to store: " + rule.getId(), (Throwable)e);
        }
    }

    public void deleteProfilingRule(ProfilingRule rule) throws ProfilerException {
        try {
            Transaction tx = this.persistentStore.getTransaction();
            tx.begin();
            this.persistentStore.deletePersistent((Object)rule);
            tx.commit();
        }
        catch (Exception e) {
            throw new ProfilerException("failed to delete: " + rule.getId(), (Throwable)e);
        }
    }

    public void storePrincipalRule(PrincipalRule rule) throws ProfilerException {
        try {
            Transaction tx = this.persistentStore.getTransaction();
            tx.begin();
            this.persistentStore.makePersistent((Object)rule);
            this.persistentStore.lockForWrite((Object)rule);
            tx.commit();
        }
        catch (Exception e) {
            throw new ProfilerException("failed to store: " + rule.getLocatorName(), (Throwable)e);
        }
    }

    public void deletePrincipalRule(PrincipalRule rule) throws ProfilerException {
        try {
            Transaction tx = this.persistentStore.getTransaction();
            tx.begin();
            this.persistentStore.deletePersistent((Object)rule);
            tx.commit();
        }
        catch (Exception e) {
            throw new ProfilerException("failed to delete: " + rule.getLocatorName(), (Throwable)e);
        }
    }

    public ProfileLocator getDefaultProfile(RequestContext context, String locatorName) throws ProfilerException {
        return null;
    }

    public Map getDefaultProfileLocators(RequestContext context) throws ProfilerException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

