/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.factory;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import org.apache.jetspeed.factory.PortletInstance;

public class JetspeedPortletInstance
implements PortletInstance {
    private Portlet portlet;
    private PortletConfig config;
    private boolean destroyed;

    public JetspeedPortletInstance(Portlet portlet) {
        this.portlet = portlet;
    }

    private void checkAvailable() throws UnavailableException {
        if (this.destroyed) {
            throw new UnavailableException("Portlet " + this.portlet.getClass().getName() + " no longer available");
        }
    }

    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
        }
        this.portlet.destroy();
    }

    public boolean equals(Object obj) {
        return this.portlet.equals(obj);
    }

    public int hashCode() {
        return this.portlet.hashCode();
    }

    public void init(PortletConfig config) throws PortletException {
        this.portlet.init(config);
        this.config = config;
    }

    public PortletConfig getConfig() {
        return this.config;
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.checkAvailable();
        this.portlet.processAction(request, response);
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.checkAvailable();
        this.portlet.render(request, response);
    }

    public String toString() {
        return this.portlet.toString();
    }
}

