/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.mcast;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.io.XByteBuffer;

public class McastMember
implements Member,
Serializable {
    static final transient char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final transient String TCP_LISTEN_PORT = "tcpListenPort";
    public static final transient String TCP_LISTEN_HOST = "tcpListenHost";
    public static final transient String MEMBER_NAME = "memberName";
    protected String host;
    protected int port;
    private String name;
    protected int msgCount = 0;
    protected long memberAliveTime = 0L;

    public McastMember(String name, String host, int port, long aliveTime) {
        this.host = host;
        this.port = port;
        this.name = name;
        this.memberAliveTime = aliveTime;
    }

    public HashMap getMemberProperties() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(TCP_LISTEN_HOST, this.host);
        map.put(TCP_LISTEN_PORT, String.valueOf(this.port));
        map.put(MEMBER_NAME, this.name);
        return map;
    }

    protected void inc() {
        ++this.msgCount;
    }

    protected byte[] getData(long startTime) throws Exception {
        byte[] named = this.getName().getBytes();
        byte[] addr = InetAddress.getByName(this.host).getAddress();
        byte[] data = new byte[12 + addr.length + named.length];
        long alive = System.currentTimeMillis() - startTime;
        System.arraycopy(XByteBuffer.toBytes(alive), 0, data, 0, 8);
        System.arraycopy(XByteBuffer.toBytes(this.port), 0, data, 8, 4);
        System.arraycopy(addr, 0, data, 12, addr.length);
        System.arraycopy(named, 0, data, 12 + addr.length, named.length);
        return data;
    }

    protected static McastMember getMember(byte[] data) {
        byte[] alived = new byte[8];
        System.arraycopy(data, 0, alived, 0, 8);
        byte[] portd = new byte[4];
        System.arraycopy(data, 8, portd, 0, 4);
        byte[] addr = new byte[4];
        System.arraycopy(data, 12, addr, 0, 4);
        byte[] named = new byte[data.length - 16];
        System.arraycopy(data, 16, named, 0, named.length);
        return new McastMember(new String(named), McastMember.addressToString(addr), XByteBuffer.toInt(portd, 0), XByteBuffer.toLong(alived, 0));
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public long getMemberAliveTime() {
        return this.memberAliveTime;
    }

    public void setMemberAliveTime(long time) {
        this.memberAliveTime = time;
    }

    public String toString() {
        return "org.apache.catalina.cluster.mcast.McastMember[" + this.name + "," + this.host + "," + this.port + ", alive=" + this.memberAliveTime + "]";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof McastMember) {
            return this.name.equals(((McastMember)o).getName());
        }
        return false;
    }

    private static final String addressToString(byte[] address) {
        int q;
        int r = 0;
        int charPos = 15;
        char[] buf = new char[15];
        int dot = 46;
        int i = address[3] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[2] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[1] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[0] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        return new String(buf, charPos, 15 - charPos);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setMsgCount(int msgCount) {
        this.msgCount = msgCount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

