/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.prefs.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import org.apache.jetspeed.prefs.NodeDoesNotExistException;
import org.apache.jetspeed.prefs.PreferencesException;
import org.apache.jetspeed.prefs.PreferencesProvider;
import org.apache.jetspeed.prefs.PropertyException;
import org.apache.jetspeed.prefs.PropertyManager;
import org.apache.jetspeed.prefs.om.Node;
import org.apache.jetspeed.prefs.om.Property;
import org.apache.jetspeed.prefs.om.PropertyKey;
import org.apache.jetspeed.prefs.om.impl.PropertyKeyImpl;
import org.apache.jetspeed.util.ArgUtil;
import org.springframework.orm.ojb.support.PersistenceBrokerDaoSupport;

public class PropertyManagerImpl
extends PersistenceBrokerDaoSupport
implements PropertyManager {
    private static final int USER_NODE_TYPE = 0;
    private static final int SYSTEM_NODE_TYPE = 1;
    protected PreferencesProvider prefsProvider;

    public PropertyManagerImpl(PreferencesProvider prefsProvider) {
        this.prefsProvider = prefsProvider;
    }

    public void addPropertyKeys(Preferences prefNode, Map propertyKeysMap) throws PropertyException, PreferencesException {
        ArgUtil.notNull((Object[])new Object[]{prefNode, propertyKeysMap}, (String[])new String[]{"prefNode", "propertyKeysMap"}, (String)"addPropertyKeys(java.util.prefs.Preferences, java.util.Collection)");
        Node nodeObj = this.getNode(prefNode);
        Collection propertyKeys = nodeObj.getNodeKeys();
        ArrayList<PropertyKey> newPropertyKeys = new ArrayList<PropertyKey>(propertyKeysMap.size());
        Iterator i = propertyKeysMap.keySet().iterator();
        while (i.hasNext()) {
            boolean foundKey = false;
            String currentPropertyKeyName = (String)i.next();
            Iterator j = propertyKeys.iterator();
            while (j.hasNext()) {
                PropertyKey existingPpk = (PropertyKey)j.next();
                if (!propertyKeysMap.containsKey(existingPpk.getPropertyKeyName())) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Existing Property: " + (String)propertyKeysMap.get(currentPropertyKeyName)));
                }
                foundKey = true;
                newPropertyKeys.add(existingPpk);
                break;
            }
            if (foundKey) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("New Property: " + currentPropertyKeyName));
            }
            PropertyKeyImpl ppk = new PropertyKeyImpl(currentPropertyKeyName, (Integer)propertyKeysMap.get(currentPropertyKeyName));
            newPropertyKeys.add(ppk);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Node: " + nodeObj.toString()));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Node property keys: " + newPropertyKeys.toString()));
        }
        nodeObj.setNodeKeys(newPropertyKeys);
        nodeObj.setModifiedDate(new Timestamp(System.currentTimeMillis()));
        this.prefsProvider.storeNode(nodeObj);
    }

    public Map getPropertyKeys(Preferences prefNode) throws PreferencesException {
        ArgUtil.notNull((Object[])new Object[]{prefNode}, (String[])new String[]{"prefNode"}, (String)"getPropertyKeys(java.util.prefs.Preferences)");
        Node nodeObj = this.getNode(prefNode);
        Collection keys = nodeObj.getNodeKeys();
        HashMap<String, Integer> propertyKeysMap = new HashMap<String, Integer>(keys.size());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            PropertyKey curpk = (PropertyKey)i.next();
            propertyKeysMap.put(curpk.getPropertyKeyName(), new Integer(curpk.getPropertyKeyType()));
        }
        return propertyKeysMap;
    }

    public void removePropertyKeys(Preferences prefNode, Collection propertyKeys) throws PropertyException, PreferencesException {
        ArgUtil.notNull((Object[])new Object[]{prefNode, propertyKeys}, (String[])new String[]{"prefNode", "propertyKeys"}, (String)"removePropertyKeys(java.util.prefs.Preferences, java.util.Collection)");
        Node nodeObj = this.getNode(prefNode);
        Collection properties = nodeObj.getNodeProperties();
        ArrayList<Property> newProperties = new ArrayList<Property>(properties.size());
        Collection keys = nodeObj.getNodeKeys();
        ArrayList<PropertyKey> newKeys = new ArrayList<PropertyKey>(keys.size());
        Iterator i = properties.iterator();
        while (i.hasNext()) {
            Property curProp = (Property)i.next();
            PropertyKey curPropKey = curProp.getPropertyKey();
            if (null == curPropKey || propertyKeys.contains(curProp.getPropertyKey().getPropertyKeyName())) continue;
            newProperties.add(curProp);
        }
        Iterator j = newKeys.iterator();
        while (j.hasNext()) {
            PropertyKey curPropKey = (PropertyKey)j.next();
            if (propertyKeys.contains(curPropKey.getPropertyKeyName())) continue;
            newKeys.add(curPropKey);
        }
        nodeObj.setNodeKeys(newKeys);
        nodeObj.setNodeProperties(newProperties);
        nodeObj.setModifiedDate(new Timestamp(System.currentTimeMillis()));
        this.prefsProvider.storeNode(nodeObj);
    }

    public void updatePropertyKey(String oldPropertyKeyName, Preferences prefNode, Map newPropertyKey) throws PropertyException, PreferencesException {
        ArgUtil.notNull((Object[])new Object[]{oldPropertyKeyName, prefNode, newPropertyKey}, (String[])new String[]{"oldPropertyKeyName", "prefNode", "newPropertyKey"}, (String)"updatePropertyKey(java.lang.String, java.util.prefs.Preferences, java.util.Map)");
        Node nodeObj = this.getNode(prefNode);
        Collection keys = nodeObj.getNodeKeys();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            PropertyKey curPropKey = (PropertyKey)i.next();
            if (!curPropKey.getPropertyKeyName().equals(oldPropertyKeyName)) continue;
            Iterator j = newPropertyKey.keySet().iterator();
            while (j.hasNext()) {
                String newKey = (String)j.next();
                curPropKey.setPropertyKeyName(newKey);
                curPropKey.setPropertyKeyType(((Integer)newPropertyKey.get(newKey)).intValue());
                curPropKey.setModifiedDate(new Timestamp(System.currentTimeMillis()));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Updated property key: " + curPropKey.toString()));
                }
                this.getPersistenceBrokerTemplate().store((Object)curPropKey);
            }
        }
    }

    protected Node getNode(Preferences prefNode) throws NodeDoesNotExistException {
        Node nodeObj = prefNode.isUserNode() ? this.prefsProvider.getNode(prefNode.absolutePath(), 0) : this.prefsProvider.getNode(prefNode.absolutePath(), 1);
        return nodeObj;
    }
}

