/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.prefs.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.prefs.FailedToCreateNodeException;
import org.apache.jetspeed.prefs.NodeAlreadyExistsException;
import org.apache.jetspeed.prefs.NodeDoesNotExistException;
import org.apache.jetspeed.prefs.PreferencesProvider;
import org.apache.jetspeed.prefs.om.Node;
import org.apache.jetspeed.prefs.om.Property;
import org.apache.jetspeed.prefs.om.PropertyKey;
import org.apache.jetspeed.prefs.om.impl.PropertyImpl;
import org.apache.jetspeed.prefs.om.impl.PropertyKeyImpl;

public class PreferencesImpl
extends AbstractPreferences {
    public static final int USER_NODE_TYPE = 0;
    public static final int SYSTEM_NODE_TYPE = 1;
    private Node node = null;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$prefs$impl$PreferencesImpl == null ? (class$org$apache$jetspeed$prefs$impl$PreferencesImpl = PreferencesImpl.class$("org.apache.jetspeed.prefs.impl.PreferencesImpl")) : class$org$apache$jetspeed$prefs$impl$PreferencesImpl));
    protected static PreferencesProvider prefsProvider;
    static PreferencesImpl systemRoot;
    static PreferencesImpl userRoot;
    static /* synthetic */ Class class$org$apache$jetspeed$prefs$impl$PreferencesImpl;

    public PreferencesImpl(PreferencesImpl parent, String nodeName, int nodeType) throws IllegalStateException {
        super(parent, nodeName);
        try {
            this.node = parent != null ? prefsProvider.createNode(parent.getNode(), nodeName, nodeType, this.absolutePath()) : prefsProvider.createNode(null, nodeName, nodeType, this.absolutePath());
            this.newNode = true;
        }
        catch (FailedToCreateNodeException e) {
            IllegalStateException ise = new IllegalStateException("Failed to create new Preferences of type " + nodeType + " for path " + this.absolutePath());
            ise.initCause(e);
            throw ise;
        }
        catch (NodeAlreadyExistsException e) {
            try {
                this.node = prefsProvider.getNode(this.absolutePath(), nodeType);
                this.newNode = false;
            }
            catch (NodeDoesNotExistException e1) {
                IllegalStateException ise = new IllegalStateException("Unable to create node for Preferences of type " + nodeType + " for path " + this.absolutePath() + ".  If you see this exception at this, it more than likely means that the Preferences backing store is corrupt.");
                ise.initCause(e1);
                throw ise;
            }
        }
    }

    public String[] childrenNamesSpi() throws BackingStoreException {
        Collection nodes = prefsProvider.getChildren(this.getNode());
        if (null != nodes) {
            ArrayList<String> childrenNames = new ArrayList<String>(nodes.size());
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                Node curnode = (Node)i.next();
                childrenNames.add(curnode.getNodeName());
            }
            return childrenNames.toArray(new String[0]);
        }
        return new String[0];
    }

    public AbstractPreferences childSpi(String name) {
        return new PreferencesImpl(this, name, this.node.getNodeType());
    }

    public void flushSpi() throws BackingStoreException {
        prefsProvider.storeNode(this.node);
    }

    public String getSpi(String key) {
        Collection properties = this.node.getNodeProperties();
        Iterator i = properties.iterator();
        while (i.hasNext()) {
            Property curProp = (Property)i.next();
            if (!curProp.getPropertyKey().getPropertyKeyName().equals(key)) continue;
            return curProp.getPropertyValue(curProp.getPropertyKey().getPropertyKeyType());
        }
        return null;
    }

    public String[] keysSpi() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        Collection propCol = this.node.getNodeProperties();
        if (null != propCol && propCol.size() > 0) {
            Iterator j = propCol.iterator();
            while (j.hasNext()) {
                Property curprop = (Property)j.next();
                propertyNames.add(curprop.getPropertyKey().getPropertyKeyName());
            }
        }
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    public void putSpi(String key, String value) {
        Collection nodeKeys = this.node.getNodeKeys();
        Collection properties = this.node.getNodeProperties();
        if (null == properties) {
            log.error((Object)("Could not retrieve node property: [key: " + key + ", value:" + value + "]"));
            return;
        }
        boolean foundProp = false;
        boolean foundKey = false;
        Iterator i = properties.iterator();
        while (i.hasNext()) {
            Property curProp = (Property)i.next();
            if (!curProp.getPropertyKey().getPropertyKeyName().equals(key)) continue;
            foundProp = true;
            foundKey = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update existing property: [" + key + ", " + value + "]"));
            }
            curProp.setPropertyValue(curProp.getPropertyKey().getPropertyKeyType(), value);
            curProp.setModifiedDate(new Timestamp(System.currentTimeMillis()));
        }
        if (prefsProvider.isPropertyManagerEnabled() && !foundProp) {
            i = nodeKeys.iterator();
            while (i.hasNext()) {
                PropertyKey curpk = (PropertyKey)i.next();
                if (!curpk.getPropertyKeyName().equals(key)) continue;
                foundKey = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New property value: [" + key + ", " + value + "]"));
                }
                properties.add(new PropertyImpl(this.node.getNodeId(), curpk.getPropertyKeyId(), curpk, curpk.getPropertyKeyType(), value));
            }
        } else if (!prefsProvider.isPropertyManagerEnabled() && !foundProp) {
            foundKey = true;
            PropertyKeyImpl pKey = new PropertyKeyImpl(key, 3);
            properties.add(new PropertyImpl(this.node.getNodeId(), pKey.getPropertyKeyId(), pKey, pKey.getPropertyKeyType(), value));
        }
        if (!foundKey) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The specified property key does not exist.");
            }
            return;
        }
        prefsProvider.storeNode(this.node);
    }

    public void removeNodeSpi() throws BackingStoreException {
        prefsProvider.removeNode(this.node);
    }

    public void removeSpi(String key) {
        Collection properties = this.node.getNodeProperties();
        Iterator i = properties.iterator();
        while (i.hasNext()) {
            Property curProp = (Property)i.next();
            if (!curProp.getPropertyKey().getPropertyKeyName().equals(key)) continue;
            i.remove();
        }
        prefsProvider.storeNode(this.node);
    }

    public void syncSpi() throws BackingStoreException {
        this.flushSpi();
    }

    public Node getNode() {
        return this.node;
    }

    public static void setPreferencesProvider(PreferencesProvider prefsProvider) {
        PreferencesImpl.prefsProvider = prefsProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

