/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.contentserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.jetspeed.contentserver.ContentLocator;
import org.apache.pluto.util.PrintWriterServletOutputStream;

public class ContentLocatingResponseWrapper
extends HttpServletResponseWrapper {
    private ContentLocator contentLocator;
    private HttpServletResponse response;
    private boolean _404sent = false;
    private boolean locationAttempted = false;
    protected boolean outputStreamCalled;
    protected boolean writerCalled;
    protected PrintWriter writer;
    protected ServletOutputStream outputStream;

    public ContentLocatingResponseWrapper(HttpServletResponse response, ContentLocator contentLocator) {
        super(response);
        this.contentLocator = contentLocator;
        this.response = response;
    }

    public void sendError(int errorCode, String arg1) throws IOException {
        this.handleError(errorCode, arg1);
    }

    public void sendError(int errorCode) throws IOException {
        this.handleError(errorCode, null);
    }

    protected void handleError(int errorCode, String message) throws IOException {
        if (errorCode == 404) {
            this._404sent = true;
            try {
                this.locationAttempted = true;
                this.setContentLength((int)this.contentLocator.writeToOutputStream((OutputStream)this.getOutputStream()));
                this.setStatus(200);
            }
            catch (FileNotFoundException e) {
                super.sendError(404, e.getMessage());
            }
        } else if (message != null) {
            super.sendError(errorCode, message);
        } else {
            super.sendError(errorCode);
        }
    }

    public boolean was404sent() {
        return this._404sent;
    }

    public boolean wasLocationAttempted() {
        return this.locationAttempted;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.outputStreamCalled = true;
        if (this.outputStream == null) {
            this.outputStream = this.writerCalled ? new PrintWriterServletOutputStream(this.writer) : super.getOutputStream();
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        this.writerCalled = true;
        if (this.writer == null) {
            this.writer = this.outputStreamCalled ? new PrintWriter((OutputStream)this.outputStream) : super.getWriter();
        }
        return this.writer;
    }
}

