/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.contentserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.contentserver.ContentLocatingRequestWrapper;
import org.apache.jetspeed.contentserver.ContentLocatingResponseWrapper;
import org.apache.jetspeed.contentserver.SimpleContentLocator;

public class ContentFilter
implements Filter {
    public static final String SESSION_CONTENT_PATH_ATTR = "org.apache.jetspeed.content.pathes";
    private FilterConfig config;
    private String contentDir;
    private File contentDirFile;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$contentserver$ContentFilter == null ? (class$org$apache$jetspeed$contentserver$ContentFilter = ContentFilter.class$("org.apache.jetspeed.contentserver.ContentFilter")) : class$org$apache$jetspeed$contentserver$ContentFilter));
    private String urlHint;
    protected String[] urlHints;
    protected boolean useCache;
    static /* synthetic */ Class class$org$apache$jetspeed$contentserver$ContentFilter;

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        String dir = config.getInitParameter("content.directory");
        this.urlHint = config.getInitParameter("url.hint");
        this.contentDir = config.getServletContext().getRealPath(dir);
        this.contentDirFile = new File(this.contentDir);
        StringTokenizer hintTokenizer = new StringTokenizer(this.urlHint, ",");
        this.urlHints = new String[hintTokenizer.countTokens()];
        int i = 0;
        while (hintTokenizer.hasMoreTokens()) {
            this.urlHints[i] = hintTokenizer.nextToken();
            ++i;
        }
        String useCacheParam = config.getInitParameter("use.caching");
        this.useCache = useCacheParam == null ? true : Boolean.valueOf(useCacheParam);
        if (!this.contentDirFile.exists()) {
            throw new ServletException("The specified content directory " + this.contentDirFile.getAbsolutePath() + " does not exist!");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String requestURI = httpRequest.getRequestURI();
            SimpleContentLocator contentLocator = new SimpleContentLocator(this.contentDir, this.urlHints, this.useCache, httpRequest.getContextPath(), requestURI, this.getContentSearchPathes(httpRequest));
            ContentLocatingResponseWrapper respWrapper = new ContentLocatingResponseWrapper(httpResponse, contentLocator);
            ContentLocatingRequestWrapper reqWrapper = new ContentLocatingRequestWrapper(httpRequest, contentLocator);
            httpRequest.setAttribute("org.apache.jetspeed.content.filtered", (Object)"true");
            chain.doFilter((ServletRequest)reqWrapper, (ServletResponse)respWrapper);
            if (!(respWrapper.wasLocationAttempted() || respWrapper.outputStreamCalled || respWrapper.writerCalled)) {
                try {
                    httpResponse.setContentLength((int)contentLocator.writeToOutputStream((OutputStream)httpResponse.getOutputStream()));
                    httpResponse.setStatus(200);
                }
                catch (FileNotFoundException e) {
                    httpResponse.sendError(404, e.getMessage());
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    protected List getContentSearchPathes(HttpServletRequest request) {
        ArrayList contentPathes = (ArrayList)request.getSession().getAttribute(SESSION_CONTENT_PATH_ATTR);
        if (contentPathes == null) {
            contentPathes = new ArrayList();
        }
        return contentPathes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

