/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.contentserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.contentserver.ContentLocator;

public abstract class AbstractContentLocator
implements ContentLocator {
    protected String rootPath;
    protected boolean useCachedLookup;
    protected static final Map fileCache = new HashMap();
    protected static final Map contentCache = new HashMap();
    protected String[] URLHints;
    protected static final Log log = LogFactory.getLog((Class)(class$org$apache$jetspeed$contentserver$SimpleContentLocator == null ? (class$org$apache$jetspeed$contentserver$SimpleContentLocator = AbstractContentLocator.class$("org.apache.jetspeed.contentserver.SimpleContentLocator")) : class$org$apache$jetspeed$contentserver$SimpleContentLocator));
    protected String contextRoot;
    protected String URI;
    protected List lookupPathes;
    private String basePath;
    static /* synthetic */ Class class$org$apache$jetspeed$contentserver$SimpleContentLocator;

    public AbstractContentLocator(String rootPath, String[] URLHints, boolean useCachedLookup, String contextRoot, String URI2, List lookupPathes) {
        this.contextRoot = contextRoot;
        this.rootPath = rootPath;
        this.useCachedLookup = useCachedLookup;
        this.URLHints = URLHints;
        this.URI = URI2;
        this.lookupPathes = lookupPathes;
    }

    public OutputStream getOutputStream() throws IOException {
        File content = new File(this.getRealPath());
        BufferedOutputStream bos = new BufferedOutputStream(new ByteArrayOutputStream((int)content.length()));
        this.writeToOutputStream(bos);
        return bos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeToOutputStream(OutputStream stream) throws IOException {
        InputStream is = this.getInputStream();
        if (is != null) {
            long l;
            try {
                long size = 0L;
                int j = is.read();
                while (j != -1) {
                    stream.write((byte)j);
                    ++size;
                    j = is.read();
                }
                l = size;
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            return l;
        }
        return -1L;
    }

    public InputStream getInputStream() throws IOException {
        String realPath = this.getRealPath();
        if (realPath == null) {
            throw new FileNotFoundException("The " + this.URI + " could not be resolved by the ContentLocator");
        }
        if (contentCache.containsKey(realPath) && this.useCachedLookup) {
            byte[] contentInBytes = (byte[])contentCache.get(realPath);
            return new BufferedInputStream(new ByteArrayInputStream(contentInBytes));
        }
        File content = new File(realPath);
        if (content != null) {
            if (this.useCachedLookup) {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(content));
                int size = (int)content.length();
                int i = 0;
                byte[] buffer = new byte[size];
                int j = bis.read();
                while (j != -1) {
                    buffer[i] = (byte)j;
                    ++i;
                    j = bis.read();
                }
                contentCache.put(realPath, buffer);
                return new BufferedInputStream(new ByteArrayInputStream(buffer));
            }
            return new BufferedInputStream(new FileInputStream(content));
        }
        throw new FileNotFoundException("Failed to load content source " + realPath);
    }

    public String getBasePath() {
        if (this.basePath == null) {
            String absPath = this.getRealPath();
            if (absPath != null) {
                absPath = absPath.replace('\\', '/');
                int startOffset = absPath.indexOf(this.contextRoot) + this.contextRoot.length();
                this.basePath = absPath.substring(startOffset, absPath.length());
            } else {
                this.basePath = this.URI;
            }
        }
        return this.basePath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

