<?php
/**
 * バリデータクラス
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */

class ClassValidator
{
    // ● 必須チェック(通常)
    public function chkR($chkStr)/*{{{*/
    {
        $flgNg = FALSE;
        if (!isset($chkStr)) {
            $flgNg = TRUE;
        }
        if (is_null($chkStr)) {
            $flgNg = TRUE;
        }
        if ($chkStr === "") {
            $flgNg = TRUE;
        }
        if ($flgNg) {
            return FALSE;
        }
        return TRUE;
    }/*}}}*/
    
    // ● 必須チェック(通常に加えて半角・全角のスペース＋改行のみも許さない)
    public function chkS($chkStr)/*{{{*/
    {
        $flgNg = FALSE;
        if (!isset($chkStr)) {
            $flgNg = TRUE;
        }
        if (is_null($chkStr)) {
            $flgNg = TRUE;
        }
        if (!$flgNg) {
            $tmp = mb_ereg_replace("　", "", $chkStr);
            $tmp = trim($tmp);
            if ($tmp === "") {
                $flgNg = TRUE;
            }
        }
        if ($flgNg) {
            return FALSE;
        }
        return TRUE;
    }/*}}}*/
    
    // ● 半角英数チェック
    public function chkE($chkStr)/*{{{*/
    {
        $eregPtr = "^[a-zA-Z0-9]+$";
        if (!$this->chkR($chkStr)) {
            return FALSE;
        }
        if (!mb_ereg($eregPtr, $chkStr)) {
            return FALSE;
        }
        return TRUE;
    }/*}}}*/
    
    // ● 数値チェック
    public function chkN($chkStr)/*{{{*/
    {
        $flgOk = FALSE;
        if (!$this->chkR($chkStr)) {
            return FALSE;
        }
        if (is_float($chkStr)) {
            $flgOk = TRUE;
        }
        if (is_int($chkStr)) {
            $flgOk = TRUE;
        }
        if (is_numeric($chkStr)) {
            $flgOk = TRUE;
        }
        if (!$flgOk) {
            return FALSE;
        }
        return TRUE;
    }/*}}}*/
    
    // ● メールアドレスとしての妥当性チェック
    public function chkM($chkStr)/*{{{*/
    {
        if (!$this->chkR($chkStr)) {
            return FALSE;
        }
        $eregPtrStrA = "\@";
        $eregPtrStrB = "^\@";
        $eregPtrStrC = "\@$";
        $eregPtrStrD = "^[a-zA-Z0-9@_.-]+$";
        if ((!mb_ereg($eregPtrStrA, $chkStr))
                || (mb_ereg($eregPtrStrB, $chkStr))
                || (mb_ereg($eregPtrStrC, $chkStr))
                || (!mb_ereg($eregPtrStrD, $chkStr))) {
            return FALSE;
        }
        return TRUE;
    }/*}}}*/
    
    // ● 半角英数＋アンダースコアチェック
    public function chkA($chkStr)/*{{{*/
    {
        $eregPtr = "^[a-zA-Z0-9_]+$";
        if (!$this->chkR($chkStr)) {
            return FALSE;
        }
        if (!mb_ereg($eregPtr, $chkStr)) {
            return FALSE;
        }
        return TRUE;
    }/*}}}*/
    
    // ● 日付の正当性チェック（時間の前後関係の比較）
    public function chkDateComp($frYyyy, $frMm, $frDd, $toYyyy, $toMm, $toDd)/*{{{*/
    {
        if (!@checkdate($frMm, $frDd, $frYyyy)) {
            return FALSE;
        }
        if (!@checkdate($toMm, $toDd, $toYyyy)) {
            return FALSE;
        }
        if (($frYyyy > $toYyyy)
                || (($frYyyy == $toYyyy) && ($frMm > $toMm))
                || (($frYyyy == $toYyyy) && ($frMm == $toMm) && ($frDd > $toDd))) {
            return FALSE;
        }
        return TRUE;
    }/*}}}*/
}

