<?php
/**
 * ログ用クラス
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */

class ClassLogger
{
    // ● メンバー変数
    ///*{{{*/
    public $fileAccess = LOG_ACCESS;
    public $fileError = LOG_ERROR;
    ///*}}}*/

    // ● コンストラクタ
    public function __construct()/*{{{*/
    {
        $this->fileAccess = sprintf("%saccess-%s.log", $this->fileAccess, date("Y-m-d"));
        $this->fileError = sprintf("%serror-%s.log", $this->fileError, date("Y-m-d"));
    }/*}}}*/

    // ● アクセスログ
    public function logAccess($msg)/*{{{*/
    {
        $msg = mb_ereg_replace("\t", " ", $msg);
        $msg = mb_ereg_replace("\n", "", $msg);
        if ($fp = @fopen($this->fileAccess, "a")) {
            @flock($fp, LOCK_EX);
            @fwrite($fp, sprintf("%s\t%s\t%s\t%s\n", date("Y-m-d H:i:s"), $_SERVER['REMOTE_ADDR'], $msg, $_SERVER["HTTP_USER_AGENT"]));
            @flock($fp, LOCK_UN);
            @fclose($fp);
        }
    }/*}}}*/

    // ● エラーログ
    public function logError($msg)/*{{{*/
    {
        $msg = mb_ereg_replace("\t", " ", $msg);
        $msg = mb_ereg_replace("\n", "", $msg);
        if ($fp = @fopen($this->fileError, "a")) {
            @flock($fp, LOCK_EX);
            @fwrite($fp, sprintf("%s\t%s\t%s\n", date("Y-m-d H:i:s"), $_SERVER['REMOTE_ADDR'], $msg));
            @flock($fp, LOCK_UN);
            @fclose($fp);
        }
    }/*}}}*/
}

