<?php
/**
 * 基本クラス
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */

class ClassBase
{
    // ● メンバー変数
    ///*{{{*/
    public $charCode = CHAR_CODE_PHP;
    public $arrPost = array();
    public $arrGet = array();
    ///*}}}*/
    
    // ● コンストラクタ
    public function __construct()/*{{{*/
    {
        $this->formPost();
        $this->formGet();
    }/*}}}*/

    // ● POST送信された値を配列に格納するメソッド
    public function formPost()/*{{{*/
    {
        foreach ($_POST as $varName => $varValue) {
            if (get_magic_quotes_gpc()) {
                if (is_array($varValue)) {
                    foreach ($varValue as $key => $value) {
                        $_POST[$varName][$key] = stripslashes($value);
                    }
                } else {
                    $_POST[$varName] = stripslashes($varValue);
                }
            }
            $this->arrPost[$varName] = $_POST[$varName];
        }
    }/*}}}*/
    
    // ● GET送信された値を配列に格納するメソッド
    public function formGet()/*{{{*/
    {
        foreach ($_GET as $varName => $varValue) {
            if (get_magic_quotes_gpc()) {
                if (is_array($varValue)) {
                    foreach ($varValue as $key => $value) {
                        $_GET[$varName][$key] = stripslashes($value);
                    }
                } else {
                    $_GET[$varName] = stripslashes($varValue);
                }
            }
            $this->arrGet[$varName] = $_GET[$varName];
        }
    }/*}}}*/
    
    // ● 半角を全角にする
    public function strUp($varStr)/*{{{*/
    {
        $varStr = @mb_convert_kana($varStr, "AKV", $this->charCode);
        $varStr = @htmlspecialchars($varStr, ENT_QUOTES);
        
        $ptrBefore = "&quot;";
        $ptrAfter = "”";
        $varStr = @mb_ereg_replace($ptrBefore, $ptrAfter, $varStr);
        
        $ptrBefore = "&#039;";
        $ptrAfter = "’";
        $varStr = @mb_ereg_replace($ptrBefore, $ptrAfter, $varStr);
        
        $ptrBefore = "\\\\";
        $ptrAfter = "￥";
        $varStr = @mb_ereg_replace($ptrBefore, $ptrAfter, $varStr);
        
        return $varStr;
    }/*}}}*/
    
    // ● htmlspecialchars関数の逆
    public function htmlspecialcharsBack($chStr)/*{{{*/
    {
        $ptrBefore = "&quot;";
        $ptrAfter = "\"";
        $chStr = @mb_ereg_replace($ptrBefore, $ptrAfter, $chStr);

        $ptrBefore = "&#039;";
        $ptrAfter = "'";
        $chStr = @mb_ereg_replace($ptrBefore, $ptrAfter, $chStr);

        $ptrBefore = "&lt;";
        $ptrAfter = "<";
        $chStr = @mb_ereg_replace($ptrBefore, $ptrAfter, $chStr);

        $ptrBefore = "&gt;";
        $ptrAfter = ">";
        $chStr = @mb_ereg_replace($ptrBefore, $ptrAfter, $chStr);

        $ptrBefore = "&amp;";
        $ptrAfter = "&";
        $chStr = @mb_ereg_replace($ptrBefore, $ptrAfter, $chStr);

        return $chStr;
    }/*}}}*/

    // ● Basic認証
    public function basicAuth()/*{{{*/
    {
        if (!isset($_SERVER["PHP_AUTH_USER"])) {
            header("WWW-Authenticate: Basic realm=\"Please Enter Your Password\"");
            header("HTTP/1.0 401 Unauthorized");
            //キャンセル時の表示
            echo "Authorization Required";
            exit;
        } else {
            if (!($_SERVER["PHP_AUTH_USER"] === AUTH_USER
                        && $_SERVER["PHP_AUTH_PW"] === AUTH_PW)) {
                //認証エラーの処理
                echo "Authorization Failed";
                exit;
            }
        }
    }/*}}}*/

    // ● hidden生成
    public function createHidden(&$arrHidden)/*{{{*/
    {
        $hiddenStr = "";
        foreach ($arrHidden as $tmpName => $tmpValue) {
            $hiddenStr .= "<INPUT type='hidden' name='$tmpName' value='$tmpValue'>";
        }
        return $hiddenStr;
    }/*}}}*/
    
    // ● リストボックスを生成
    public function createListbox($name, $data, $delimiter, $value = null)/*{{{*/
    {
        $arr = mb_split($delimiter, $data);
        $str = sprintf("<SELECT name='%s'>", $name);
        for ($i = 0; $i < count($arr); $i++) {
            if (is_null($value)) {
                $str .= sprintf("<OPTION value='%s'>%s</OPTION>", $i, $arr[$i]);
            } else {
                if ($i == $value) {
                    $str .= sprintf("<OPTION value='%s' selected>%s</OPTION>", $i, $arr[$i]);
                } else {
                    $str .= sprintf("<OPTION value='%s'>%s</OPTION>", $i, $arr[$i]);
                }
            }
        }
        $str .= "</SELECT>";
        return $str;
    }/*}}}*/

    // ● 曜日を日本語に変換
    public function day2japanese($yyyy, $mm, $dd)/*{{{*/
    {
        $arr = getdate(strtotime(sprintf("%s-%s-%s", $yyyy, $mm, $dd)));
        $day = $arr['weekday'];
        switch ($day) {
        case "Sunday":
        case "Sun":
            return "日";
            break;
        case "Monday":
        case "Mon":
            return "月";
            break;
        case "Tuesday":
        case "Tue":
            return "火";
            break;
        case "Wednesday":
        case "Wed":
            return "水";
            break;
        case "Thursday":
        case "Thu":
            return "木";
            break;
        case "Friday":
        case "Fri":
            return "金";
            break;
        case "Saturday":
        case "Sat":
            return "土";
            break;
        default:
            return $day;
            break;
        }
    }/*}}}*/

    // ● 生年月日から現在の年齢を求める
    public function howOld($yyyy, $mm, $dd)/*{{{*/
    {
        $nowYyyy = date("Y");
        $nowMm = date("m");
        $nowDd = date("d");
        $nowYyyy -= $yyyy;
        if (($mm * 100 + $dd) > ($nowMm * 100 + $nowDd)) {
            $nowYyyy--;
        }
        return $nowYyyy;
    }/*}}}*/

    // ● htmlspecialcharsのエイリアス
    public function h($str)/*{{{*/
    {
        return @htmlspecialchars($str, ENT_QUOTES);
    }/*}}}*/
}

