/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.wizards;

import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.ModifyLayerCompSettingsOperation;
import ch.kuramo.javie.app.project.NewLayerCompositionOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.wizards.CompositionSettings;
import ch.kuramo.javie.app.wizards.CompositionWizardPage;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.LayerComposition;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchPage;

public class CompositionWizard
extends Wizard {
    private static CompositionSettings _defaultSettings = new CompositionSettings();
    private final ProjectManager _projectManager;
    private final Folder _parent;
    private final CompositionItem _compItem;
    private CompositionWizardPage _page;

    public CompositionWizard(ProjectManager projectManager, Folder parent) {
        this._projectManager = projectManager;
        this._parent = parent;
        this._compItem = null;
        this.setWindowTitle("\u65b0\u898f\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3");
    }

    public CompositionWizard(ProjectManager projectManager, CompositionItem compItem) {
        this._projectManager = projectManager;
        this._parent = null;
        this._compItem = compItem;
        this.setWindowTitle("\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u8a2d\u5b9a");
    }

    public void addPages() {
        if (this._compItem == null) {
            CompositionSettings settings = _defaultSettings.clone();
            settings.name = this._projectManager.getUnusedItemName("\u30b3\u30f3\u30dd");
            settings.frameDurationPreserved = false;
            this._page = new CompositionWizardPage(settings, true);
        } else {
            CompositionSettings settings = new CompositionSettings();
            settings.name = this._compItem.getName();
            LayerComposition comp = (LayerComposition)this._compItem.getComposition();
            settings.size = comp.getSize();
            settings.frameDuration = comp.getFrameDuration();
            settings.duration = comp.getDuration();
            settings.colorMode = comp.getColorMode();
            settings.frameDurationPreserved = comp.isFrameDurationPreserved();
            settings.motionBlurShutterAngle = comp.getMotionBlurShutterAngle();
            settings.motionBlurShutterPhase = comp.getMotionBlurShutterPhase();
            settings.motionBlurSamples = comp.getMotionBlurSamples();
            this._page = new CompositionWizardPage(settings, false);
        }
        this.addPage((IWizardPage)this._page);
    }

    public boolean performFinish() {
        CompositionSettings settings = this._page.getResult();
        if (settings == null) {
            return false;
        }
        IWorkbenchPage page = this._projectManager.getWorkbenchWindow().getActivePage();
        if (this._compItem == null) {
            NewLayerCompositionOperation op = new NewLayerCompositionOperation(this._projectManager, this._parent, settings.name, settings.colorMode, settings.size, settings.frameDuration, settings.duration, settings.frameDurationPreserved, settings.motionBlurShutterAngle, settings.motionBlurShutterPhase, settings.motionBlurSamples);
            this._projectManager.postOperation(op);
            String compItemId = op.getCompositionItemId();
            UIUtil.showView(page, "ch.kuramo.javie.app.views.layerCompositionView", compItemId, 1);
            UIUtil.showView(page, "ch.kuramo.javie.app.views.mediaPlayerView", compItemId, 2);
        } else {
            ModifyLayerCompSettingsOperation op = new ModifyLayerCompSettingsOperation(this._projectManager, this._compItem, settings.name, settings.colorMode, settings.size, settings.frameDuration, settings.duration, settings.frameDurationPreserved, settings.motionBlurShutterAngle, settings.motionBlurShutterPhase, settings.motionBlurSamples);
            this._projectManager.postOperation(op);
        }
        _defaultSettings = settings;
        return true;
    }
}

