/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveTASelectorsOperation
extends ProjectOperation {
    private final String _compId;
    private final List<int[]> _srcData;
    private final String _dstLayerId;
    private final int _dstAnimatorIndex;
    private final int _dstIndex;

    public MoveTASelectorsOperation(ProjectManager pm, List<Object[]> selectors, TextLayer dstLayer, TextAnimator dstAnimator, int moveBefore) {
        super(pm, "\u30bb\u30ec\u30af\u30bf\u306e\u79fb\u52d5");
        if (selectors.isEmpty()) {
            this._noEffect = true;
            this._compId = null;
            this._srcData = null;
            this._dstLayerId = null;
            this._dstAnimatorIndex = 0;
            this._dstIndex = 0;
            return;
        }
        LayerComposition comp = pm.checkLayer((Layer)((TextLayer)selectors.get(0)[0]));
        if (pm.checkLayer((Layer)dstLayer) != comp) {
            throw new IllegalArgumentException();
        }
        this._compId = comp.getId();
        this._srcData = Util.newList();
        this._dstLayerId = dstLayer.getId();
        this._dstAnimatorIndex = dstLayer.getTextAnimators().indexOf(dstAnimator);
        int dstSelectorCount = dstAnimator.getSelectors().size();
        int dstIndex = moveBefore < 0 || moveBefore > dstSelectorCount ? (moveBefore = dstSelectorCount) : moveBefore;
        List tmp1 = Util.newList();
        for (Object[] o : selectors) {
            TextLayer srcLayer = (TextLayer)o[0];
            TextAnimator srcAnimator = (TextAnimator)o[1];
            TASelector selector = (TASelector)o[2];
            int layerIndex = comp.getLayers().indexOf(srcLayer);
            if (layerIndex == -1) {
                throw new IllegalArgumentException();
            }
            int animatorIndex = srcLayer.getTextAnimators().indexOf(srcAnimator);
            if (animatorIndex == -1) {
                throw new IllegalArgumentException();
            }
            int selectorIndex = srcAnimator.getSelectors().indexOf(selector);
            if (selectorIndex == -1) {
                throw new IllegalArgumentException();
            }
            this._srcData.add(new int[]{layerIndex, animatorIndex, selectorIndex});
            if (srcAnimator == dstAnimator && selectorIndex < moveBefore) {
                --dstIndex;
            }
            tmp1.add(selector);
        }
        this._dstIndex = dstIndex;
        Collections.sort(this._srcData, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                int compare = o1[0] - o2[0];
                if (compare != 0) {
                    return compare;
                }
                compare = o1[1] - o2[1];
                if (compare != 0) {
                    return compare;
                }
                return o2[2] - o1[2];
            }
        });
        List tmp2 = Util.newList((Collection)dstAnimator.getSelectors());
        tmp2.removeAll(tmp1);
        tmp2.addAll(this._dstIndex, tmp1);
        this._noEffect = dstAnimator.getSelectors().equals(tmp2);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        TextLayer dstLayer = (TextLayer)comp.getLayer(this._dstLayerId);
        TextAnimator dstAnimator = (TextAnimator)dstLayer.getTextAnimators().get(this._dstAnimatorIndex);
        List data1 = null;
        List data2 = null;
        if (pm != null) {
            data1 = Util.newList();
            data2 = Util.newList();
        }
        List selectors = Util.newList();
        for (int[] srcData : this._srcData) {
            TextLayer srcLayer = (TextLayer)comp.getLayers().get(srcData[0]);
            TextAnimator srcAnimator = (TextAnimator)srcLayer.getTextAnimators().get(srcData[1]);
            selectors.add(0, (TASelector)srcAnimator.getSelectors().remove(srcData[2]));
            if (pm == null) continue;
            data1.add(new Object[]{srcLayer, srcData[1], -1});
            data2.add(new Object[]{dstLayer, this._dstAnimatorIndex, this._dstIndex + data2.size()});
        }
        if (pm != null) {
            pm.fireTASelectorsRemove(comp, (Object[][])data1.toArray((T[])new Object[data1.size()][]));
        }
        dstAnimator.getSelectors().addAll(this._dstIndex, selectors);
        if (pm != null) {
            pm.fireTASelectorsAdd(comp, (Object[][])data2.toArray((T[])new Object[data2.size()][]));
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        TextLayer dstLayer = (TextLayer)comp.getLayer(this._dstLayerId);
        TextAnimator dstAnimator = (TextAnimator)dstLayer.getTextAnimators().get(this._dstAnimatorIndex);
        List data = null;
        if (pm != null) {
            data = Util.newList();
        }
        List sublist = dstAnimator.getSelectors().subList(this._dstIndex, this._dstIndex + this._srcData.size());
        List selectors = Util.newList(sublist);
        sublist.clear();
        if (pm != null) {
            pm.fireTASelectorsRemove(comp, new Object[][]{{dstLayer, this._dstAnimatorIndex, -1}});
        }
        ListIterator<int[]> it = this._srcData.listIterator(this._srcData.size());
        while (it.hasPrevious()) {
            int[] srcData = it.previous();
            TextLayer srcLayer = (TextLayer)comp.getLayers().get(srcData[0]);
            TextAnimator srcAnimator = (TextAnimator)srcLayer.getTextAnimators().get(srcData[1]);
            srcAnimator.getSelectors().add(srcData[2], (TASelector)selectors.remove(0));
            if (pm == null) continue;
            data.add(new Object[]{srcLayer, srcData[1], srcData[2]});
        }
        if (pm != null) {
            pm.fireTASelectorsAdd(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
        return Status.OK_STATUS;
    }
}

