/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ModifyEffectExpressionOperation;
import ch.kuramo.javie.app.project.ModifyLayerExpressionOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.app.project.ProjectOperationCollection;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Util;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class AddExpressionsOperation
extends ProjectOperationCollection {
    private final String _compId;

    public AddExpressionsOperation(ProjectManager projectManager, LayerComposition comp) {
        super(projectManager, "\u30a8\u30af\u30b9\u30d7\u30ec\u30c3\u30b7\u30e7\u30f3\u306e\u8ffd\u52a0");
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.execute(monitor, info);
        if (status.isOK()) {
            this.fireExpressionsAddRemove(true);
        }
        return status;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.redo(monitor, info);
        if (status.isOK()) {
            this.fireExpressionsAddRemove(true);
        }
        return status;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.undo(monitor, info);
        if (status.isOK()) {
            this.fireExpressionsAddRemove(false);
        }
        return status;
    }

    private Object[][] createData(LayerComposition comp) {
        List data = Util.newList();
        for (ProjectOperation op : this.list) {
            ProjectOperation modifyOp;
            if (op instanceof ModifyLayerExpressionOperation) {
                modifyOp = (ModifyLayerExpressionOperation)op;
                data.add(new Object[]{comp.getLayer(((ModifyLayerExpressionOperation)modifyOp).getLayerId()), ((ModifyLayerExpressionOperation)modifyOp).getProperty()});
                continue;
            }
            if (!(op instanceof ModifyEffectExpressionOperation)) continue;
            modifyOp = (ModifyEffectExpressionOperation)op;
            data.add(new Object[]{comp.getLayer(((ModifyEffectExpressionOperation)modifyOp).getLayerId()), ((ModifyEffectExpressionOperation)modifyOp).getEffectIndex(), ((ModifyEffectExpressionOperation)modifyOp).getProperty()});
        }
        return (Object[][])data.toArray((T[])new Object[data.size()][]);
    }

    private void fireExpressionsAddRemove(boolean add) {
        LayerComposition comp = (LayerComposition)this.projectManager.getProject().getComposition(this._compId);
        Object[][] data = this.createData(comp);
        if (add) {
            this.projectManager.fireExpressionsAdd(comp, data);
        } else {
            this.projectManager.fireExpressionsRemove(comp, data);
        }
    }
}

