/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.player;

import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.player.MediaPlayer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PlayerZoomAction
extends Action
implements IMenuCreator {
    private static final double[] ZOOMS_IN_PERCENT = new double[]{12.5, 25.0, 33.3, 50.0, 100.0, 200.0, 400.0};
    private final MediaPlayer mediaPlayer;
    private Menu menu;

    public PlayerZoomAction(MediaPlayer mediaPlayer) {
        super("\u62e1\u5927\u7387");
        this.mediaPlayer = mediaPlayer;
        this.setImageDescriptor(ImageUtil.getPlayerZoomIcon());
        this.setMenuCreator(this);
        this.setEnabled(mediaPlayer.hasVideo());
    }

    public void dispose() {
        this.disposeMenu();
    }

    private void disposeMenu() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Control parent) {
        this.disposeMenu();
        if (!this.isEnabled()) {
            return null;
        }
        this.menu = new Menu(parent);
        this.addAction(this.menu, 0.0);
        new MenuItem(this.menu, 2);
        double[] dArray = ZOOMS_IN_PERCENT;
        int n = ZOOMS_IN_PERCENT.length;
        int n2 = 0;
        while (n2 < n) {
            double percent = dArray[n2];
            this.addAction(this.menu, percent);
            ++n2;
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void addAction(Menu parent, double percent) {
        String text = percent == 0.0 ? "\u5168\u4f53\u8868\u793a" : (percent == (double)((int)percent) ? String.valueOf(String.valueOf((int)percent)) + " %" : String.valueOf(String.valueOf(percent)) + " %");
        final double zoom = percent / 100.0;
        Action action = new Action(text, 8){

            public void run() {
                PlayerZoomAction.this.mediaPlayer.setVideoZoom(zoom);
            }
        };
        action.setChecked(zoom == this.mediaPlayer.getVideoZoom());
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar control = toolItem.getParent();
            Menu menu = this.getMenu((Control)control);
            Rectangle bounds = toolItem.getBounds();
            Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
            menu.setLocation(control.toDisplay(topLeft));
            menu.setVisible(true);
        }
    }
}

