/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.BatchStore;
import ch.kuramo.javie.app.ColorUtil;
import ch.kuramo.javie.app.views.LocalSelectionWrapper;
import ch.kuramo.javie.app.widgets.FontUtil;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.output.ProgressMonitor;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

class BatchOutputDialog
extends Dialog {
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private static final int REMOVE_ID = 1025;
    private static final int PENDING_ID = 1026;
    private static final int RETRY_ID = 1027;
    private final List<BatchStore.BatchEntry> entries = BatchStore.listEntries();
    private TreeViewer treeViewer;

    BatchOutputDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.y = Math.max(size.y, 400);
        return size;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\u30d0\u30c3\u30c1\u51fa\u529b");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 0;
        layout.marginTop = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(composite, 68354);
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        });
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(!COCOA);
        FontUtil.setCompatibleFont((Control)tree);
        tree.setBackground(ColorUtil.tableBackground());
        if (COCOA) {
            final Color lineColor = ColorUtil.tableRowLine();
            tree.addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    int x = event.x;
                    int y = event.y + event.height - 1;
                    GC gc = event.gc;
                    gc.setForeground(lineColor);
                    gc.drawLine(x, y, x + event.width, y);
                }
            });
        }
        this.createViewerColumn(65, "\u72b6\u6cc1");
        this.createViewerColumn(200, "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb");
        this.createViewerColumn(100, "\u30d7\u30ed\u30b8\u30a7\u30af\u30c8");
        this.createViewerColumn(100, "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3");
        this.createViewerColumn(100, "\u767b\u9332");
        this.createViewerColumn(100, "\u958b\u59cb");
        this.createViewerColumn(100, "\u5b8c\u4e86");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BatchOutputDialog.this.updateControls();
            }
        });
        this.initDragAndDrop();
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        this.treeViewer.setInput(this.entries);
        return composite;
    }

    private TreeViewerColumn createViewerColumn(int width, String name) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setWidth(width);
        column.setText(name);
        column.setMoveable(true);
        viewerColumn.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new BatchLabelProvider()));
        return viewerColumn;
    }

    private void initDragAndDrop() {
        final LocalSelectionTransfer selectionTransfer = LocalSelectionTransfer.getTransfer();
        DragSourceListener sourceListener = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionWrapper selection = new LocalSelectionWrapper((Viewer)BatchOutputDialog.this.treeViewer);
                if (selection.isEmpty()) {
                    event.doit = false;
                } else {
                    selectionTransfer.setSelection((ISelection)selection);
                    selectionTransfer.setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                    event.doit = true;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = selectionTransfer.getSelection();
            }

            public void dragFinished(DragSourceEvent event) {
                selectionTransfer.setSelection(null);
                selectionTransfer.setSelectionSetTime(0L);
            }
        };
        DropTargetAdapter targetListener = new DropTargetAdapter(){

            private boolean isAcceptable(DropTargetEvent event) {
                if (!selectionTransfer.isSupportedType(event.currentDataType)) {
                    return false;
                }
                ITreeSelection selection = (ITreeSelection)LocalSelectionWrapper.getSelection(selectionTransfer, (Viewer)BatchOutputDialog.this.treeViewer);
                return selection != null;
            }

            public void dragOver(DropTargetEvent event) {
                if (!this.isAcceptable(event)) {
                    event.detail = 0;
                    event.feedback = 0;
                    return;
                }
                event.detail = event.operations & 2;
                event.feedback = (event.feedback | 2) & 0xFFFFFFFE & 0xFFFFFFEF;
            }

            public void dropAccept(DropTargetEvent event) {
                this.dragOver(event);
            }

            public void drop(DropTargetEvent event) {
                ITreeSelection selection = (ITreeSelection)LocalSelectionWrapper.getSelection(selectionTransfer, (Viewer)BatchOutputDialog.this.treeViewer);
                if (selection == null) {
                    event.detail = 0;
                    return;
                }
                List srcList = selection.toList();
                if (event.item == null) {
                    BatchOutputDialog.this.entries.removeAll(srcList);
                    BatchOutputDialog.this.entries.addAll(srcList);
                } else {
                    Object target = event.item.getData();
                    List srcList2 = Util.newList((Collection)srcList);
                    boolean targetIsSrc = srcList2.remove(target);
                    BatchOutputDialog.this.entries.removeAll(srcList2);
                    int targetIndex = BatchOutputDialog.this.entries.indexOf(target);
                    if (targetIsSrc) {
                        BatchOutputDialog.this.entries.remove(target);
                    }
                    BatchOutputDialog.this.entries.addAll(targetIndex, srcList);
                }
                BatchStore.saveEntries(BatchOutputDialog.this.entries);
                BatchOutputDialog.this.treeViewer.refresh();
            }
        };
        this.treeViewer.addDragSupport(2, new Transfer[]{selectionTransfer}, sourceListener);
        this.treeViewer.addDropSupport(2, new Transfer[]{selectionTransfer}, (DropTargetListener)targetListener);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        ((GridData)parent.getLayoutData()).horizontalAlignment = 4;
        this.createButton(parent, 1025, "\u524a\u9664", false);
        this.createButton(parent, 1026, "\u4fdd\u7559", false);
        this.createButton(parent, 1027, "\u518d\u958b", false);
        Button dummy = this.createButton(parent, 1024, "", false);
        ((GridData)dummy.getLayoutData()).grabExcessHorizontalSpace = true;
        dummy.setVisible(false);
        this.createButton(parent, 0, "\u51fa\u529b\u958b\u59cb", true);
        this.createButton(parent, 1, "\u9589\u3058\u308b", false);
    }

    public void create() {
        super.create();
        this.updateControls();
    }

    private void updateControls() {
        Button removeButton = this.getButton(1025);
        Button pendingButton = this.getButton(1026);
        Button retryButton = this.getButton(1027);
        Button okButton = this.getButton(0);
        ITreeSelection selection = (ITreeSelection)this.treeViewer.getSelection();
        boolean removeButtonEnabled = false;
        boolean pendingButtonEnabled = false;
        boolean retryButtonEnabled = false;
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            switch (((BatchStore.BatchEntry)it.next()).state) {
                case READY: {
                    removeButtonEnabled = true;
                    pendingButtonEnabled = true;
                    break;
                }
                case CANCELED: 
                case PENDING: 
                case ERROR: {
                    removeButtonEnabled = true;
                    retryButtonEnabled = true;
                    break;
                }
                case DONE: {
                    retryButtonEnabled = true;
                    break;
                }
                case REMOVED: {
                    pendingButtonEnabled = true;
                    retryButtonEnabled = true;
                }
            }
        }
        removeButton.setEnabled(removeButtonEnabled);
        pendingButton.setEnabled(pendingButtonEnabled);
        retryButton.setEnabled(retryButtonEnabled);
        boolean okButtonEnabled = false;
        for (BatchStore.BatchEntry entry : this.entries) {
            if (entry.state != BatchStore.BatchState.READY) continue;
            okButtonEnabled = true;
            break;
        }
        okButton.setEnabled(okButtonEnabled);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId < 1024) {
            super.buttonPressed(buttonId);
            return;
        }
        ITreeSelection selection = (ITreeSelection)this.treeViewer.getSelection();
        for (BatchStore.BatchEntry entry : selection) {
            switch (buttonId) {
                case 1025: {
                    entry.state = BatchStore.BatchState.REMOVED;
                    break;
                }
                case 1026: {
                    entry.state = BatchStore.BatchState.PENDING;
                    break;
                }
                case 1027: {
                    entry.state = BatchStore.BatchState.READY;
                    entry.startTime = null;
                    entry.endTime = null;
                }
            }
        }
        BatchStore.saveEntries(this.entries);
        this.treeViewer.update(selection.toArray(), null);
        this.updateControls();
    }

    protected void cancelPressed() {
        super.cancelPressed();
        BatchStore.cleanup();
    }

    /*
     * Exception decompiling
     */
    protected void okPressed() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ProgressMonitor createProgressMonitor(final IProgressMonitor monitor, final String compName) {
        return new ProgressMonitor(){
            private int totalWork;
            private int currentWork;

            public void beginTask(int totalWork) {
                monitor.beginTask(String.format("\u66f8\u304d\u51fa\u3057: %s", compName), totalWork);
                this.totalWork = totalWork;
            }

            public void currentWork(int currentWork) {
                if (currentWork > this.currentWork) {
                    monitor.worked(currentWork - this.currentWork);
                    monitor.subTask(String.format("%.1f%%", 100.0 * (double)currentWork / (double)this.totalWork));
                    this.currentWork = currentWork;
                }
            }

            public void done() {
                monitor.done();
            }

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        };
    }

    private static class BatchLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final DateFormat df = DateFormat.getDateTimeInstance(3, 3);

        private BatchLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            BatchStore.BatchEntry entry = (BatchStore.BatchEntry)element;
            switch (columnIndex) {
                case 0: {
                    return this.getState(entry);
                }
                case 1: {
                    return entry.file.getName();
                }
                case 2: {
                    return entry.projectName;
                }
                case 3: {
                    return entry.compositionName;
                }
                case 4: {
                    return this.formatDate(entry.registeredTime);
                }
                case 5: {
                    return this.formatDate(entry.startTime);
                }
                case 6: {
                    return this.formatDate(entry.endTime);
                }
            }
            return null;
        }

        private String getState(BatchStore.BatchEntry entry) {
            switch (entry.state) {
                case READY: {
                    return "";
                }
                case IN_PROGRESS: {
                    return "\u51fa\u529b\u4e2d";
                }
                case CANCELED: {
                    return "\u4e2d\u6b62";
                }
                case PENDING: {
                    return "\u4fdd\u7559";
                }
                case ERROR: {
                    return "\u30a8\u30e9\u30fc";
                }
                case DONE: {
                    return "\u5b8c\u4e86";
                }
                case REMOVED: {
                    return "\u524a\u9664";
                }
            }
            return entry.state.name();
        }

        private String formatDate(Date date) {
            return date != null ? df.format(date) : "";
        }
    }
}

