/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.audio;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IAudioEffectContext;
import com.google.inject.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.javie.StereoMixer", category="ch.kuramo.javie.api.effectCategory.audio")
public class StereoMixer {
    @Property(value="100", min="0", max="400")
    private IAnimatableDouble leftLevel;
    @Property(value="100", min="0", max="400")
    private IAnimatableDouble rightLevel;
    @Property(value="-100", min="-100", max="100")
    private IAnimatableDouble leftPan;
    @Property(value="100", min="-100", max="100")
    private IAnimatableDouble rightPan;
    @Property
    private IAnimatableBoolean invertPhase;
    private final IAudioEffectContext context;

    @Inject
    public StereoMixer(IAudioEffectContext context) {
        this.context = context;
    }

    public IAudioBuffer doAudioEffect() {
        IObjectArray leftLevels = this.context.values((IAnimatableValue)this.leftLevel);
        IObjectArray rightLevels = this.context.values((IAnimatableValue)this.rightLevel);
        IObjectArray leftPans = this.context.values((IAnimatableValue)this.leftPan);
        IObjectArray rightPans = this.context.values((IAnimatableValue)this.rightPan);
        IObjectArray phases = this.context.values((IAnimatableValue)this.invertPhase);
        IAudioBuffer ab = this.context.doPreviousEffect();
        Object data = ab.getData();
        int frameCount = ab.getFrameCount();
        switch (ab.getAudioMode().dataType) {
            case SHORT: {
                this.mixer((short[])data, frameCount, (IObjectArray<Double>)leftLevels, (IObjectArray<Double>)rightLevels, (IObjectArray<Double>)leftPans, (IObjectArray<Double>)rightPans, (IObjectArray<Boolean>)phases);
                break;
            }
            case INT: {
                this.mixer((int[])data, frameCount, (IObjectArray<Double>)leftLevels, (IObjectArray<Double>)rightLevels, (IObjectArray<Double>)leftPans, (IObjectArray<Double>)rightPans, (IObjectArray<Boolean>)phases);
                break;
            }
            case FLOAT: {
                this.mixer((float[])data, frameCount, (IObjectArray<Double>)leftLevels, (IObjectArray<Double>)rightLevels, (IObjectArray<Double>)leftPans, (IObjectArray<Double>)rightPans, (IObjectArray<Boolean>)phases);
            }
        }
        leftLevels.release();
        rightLevels.release();
        leftPans.release();
        rightPans.release();
        phases.release();
        return ab;
    }

    private void mixer(short[] data, int frameCount, IObjectArray<Double> leftLevels, IObjectArray<Double> rightLevels, IObjectArray<Double> leftPans, IObjectArray<Double> rightPans, IObjectArray<Boolean> phases) {
        Object[] leftLevelsArray = (Object[])leftLevels.getArray();
        Object[] rightLevelsArray = (Object[])rightLevels.getArray();
        Object[] leftPansArray = (Object[])leftPans.getArray();
        Object[] rightPansArray = (Object[])rightPans.getArray();
        Object[] phasesArray = (Object[])phases.getArray();
        int i = 0;
        while (i < frameCount) {
            double leftLevel = (Double)leftLevelsArray[i] / 100.0;
            double rightLevel = (Double)rightLevelsArray[i] / 100.0;
            double leftPan = ((Double)leftPansArray[i] - 100.0) / -200.0;
            double rightPan = ((Double)rightPansArray[i] + 100.0) / 200.0;
            double phase = (Boolean)phasesArray[i] != false ? -1.0 : 1.0;
            double left = (double)data[i * 2] * leftLevel;
            double right = (double)data[i * 2 + 1] * rightLevel;
            data[i * 2] = this.clampToShort((left * leftPan + right * (1.0 - rightPan)) * phase);
            data[i * 2 + 1] = this.clampToShort((right * rightPan + left * (1.0 - leftPan)) * phase);
            ++i;
        }
    }

    private void mixer(int[] data, int frameCount, IObjectArray<Double> leftLevels, IObjectArray<Double> rightLevels, IObjectArray<Double> leftPans, IObjectArray<Double> rightPans, IObjectArray<Boolean> phases) {
        Object[] leftLevelsArray = (Object[])leftLevels.getArray();
        Object[] rightLevelsArray = (Object[])rightLevels.getArray();
        Object[] leftPansArray = (Object[])leftPans.getArray();
        Object[] rightPansArray = (Object[])rightPans.getArray();
        Object[] phasesArray = (Object[])phases.getArray();
        int i = 0;
        while (i < frameCount) {
            double leftLevel = (Double)leftLevelsArray[i] / 100.0;
            double rightLevel = (Double)rightLevelsArray[i] / 100.0;
            double leftPan = ((Double)leftPansArray[i] - 100.0) / -200.0;
            double rightPan = ((Double)rightPansArray[i] + 100.0) / 200.0;
            double phase = (Boolean)phasesArray[i] != false ? -1.0 : 1.0;
            double left = (double)data[i * 2] * leftLevel;
            double right = (double)data[i * 2 + 1] * rightLevel;
            data[i * 2] = this.clampToInt((left * leftPan + right * (1.0 - rightPan)) * phase);
            data[i * 2 + 1] = this.clampToInt((right * rightPan + left * (1.0 - leftPan)) * phase);
            ++i;
        }
    }

    private void mixer(float[] data, int frameCount, IObjectArray<Double> leftLevels, IObjectArray<Double> rightLevels, IObjectArray<Double> leftPans, IObjectArray<Double> rightPans, IObjectArray<Boolean> phases) {
        Object[] leftLevelsArray = (Object[])leftLevels.getArray();
        Object[] rightLevelsArray = (Object[])rightLevels.getArray();
        Object[] leftPansArray = (Object[])leftPans.getArray();
        Object[] rightPansArray = (Object[])rightPans.getArray();
        Object[] phasesArray = (Object[])phases.getArray();
        int i = 0;
        while (i < frameCount) {
            double leftLevel = (Double)leftLevelsArray[i] / 100.0;
            double rightLevel = (Double)rightLevelsArray[i] / 100.0;
            double leftPan = ((Double)leftPansArray[i] - 100.0) / -200.0;
            double rightPan = ((Double)rightPansArray[i] + 100.0) / 200.0;
            double phase = (Boolean)phasesArray[i] != false ? -1.0 : 1.0;
            double left = (double)data[i * 2] * leftLevel;
            double right = (double)data[i * 2 + 1] * rightLevel;
            data[i * 2] = (float)((left * leftPan + right * (1.0 - rightPan)) * phase);
            data[i * 2 + 1] = (float)((right * rightPan + left * (1.0 - leftPan)) * phase);
            ++i;
        }
    }

    private short clampToShort(double d) {
        return (short)Math.min(Math.max(d, -32768.0), 32767.0);
    }

    private int clampToInt(double d) {
        return (int)Math.min(Math.max(d, -2.147483648E9), 2.147483647E9);
    }
}

