/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.internal.AviSynthSource;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class AviSynthWrapSource
extends AviSynthSource {
    @Inject
    public AviSynthWrapSource(RenderContext context, IVideoRenderSupport vrSupport, AudioRenderSupport arSupport, IArrayPools arrayPools, Injector injector) {
        super(context, vrSupport, arSupport, arrayPools, injector);
    }

    public boolean initialize(File file) {
        if (this.hasExtension(file, "avi") && this.initialize(file, false)) {
            return true;
        }
        return this.initialize(file, true);
    }

    private boolean initialize(File file, boolean ds) {
        File avsFile = null;
        try {
            avsFile = File.createTempFile("tmp", ".avs");
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(avsFile), "Windows-31J"));
            try {
                pw.printf("%s(\"%s\", pixel_type=\"RGB32\")%n", ds ? "DirectShowSource" : "AVISource", file.getAbsolutePath());
                pw.println("return last");
            }
            finally {
                pw.close();
            }
            boolean bl = super.initialize(avsFile);
            return bl;
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
        finally {
            if (avsFile != null) {
                avsFile.delete();
            }
        }
    }
}

