/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import java.util.Arrays;
import java.util.EnumSet;
import net.arnx.jsonic.JSONHint;

public class MediaOptions
implements Cloneable {
    private EnumSet<Option> availableOptions;
    private AlphaType alphaType;
    private Color colorMatte;
    private Time videoFrameDuration;
    private Time duration;
    private Size2i size;
    private boolean flipVertical;

    public MediaOptions() {
        this.clearAvailableOptions();
    }

    public MediaOptions(Option ... availableOptions) {
        this.setAvailableOptions(availableOptions);
    }

    public void clearAvailableOptions() {
        this.setAvailableOptions(new Option[0]);
    }

    @JSONHint(ignore=true)
    public void setAvailableOptions(Option ... availableOptions) {
        EnumSet<Option> set;
        EnumSet<Option> enumSet = set = availableOptions.length > 0 ? EnumSet.copyOf(Arrays.asList(availableOptions)) : EnumSet.noneOf(Option.class);
        if (set.contains((Object)Option.VIDEO_FRAME_DURATION) && set.contains((Object)Option.DURATION)) {
            throw new IllegalArgumentException("VIDEO_FRAME_DURATION and DURATION cannot be used together.");
        }
        this.availableOptions = set;
        this.validate();
    }

    private void validate() {
        AlphaType defaultAlphaType = this.isAvailable(Option.STRAIGHT_ALPHA) ? AlphaType.STRAIGHT : (this.isAvailable(Option.PREMULTIPLIED_ALPHA) ? AlphaType.PREMULTIPLIED : (this.isAvailable(Option.IGNORE_ALPHA) ? AlphaType.IGNORE : null));
        if (this.alphaType == null) {
            this.alphaType = defaultAlphaType;
        } else {
            switch (this.alphaType) {
                case IGNORE: {
                    if (this.isAvailable(Option.IGNORE_ALPHA)) break;
                    this.alphaType = defaultAlphaType;
                    break;
                }
                case STRAIGHT: {
                    if (this.isAvailable(Option.STRAIGHT_ALPHA)) break;
                    this.alphaType = defaultAlphaType;
                    break;
                }
                case PREMULTIPLIED: {
                    if (this.isAvailable(Option.PREMULTIPLIED_ALPHA)) break;
                    this.alphaType = defaultAlphaType;
                }
            }
        }
        if (this.colorMatte == null && this.isAvailable(Option.PREMULTIPLIED_ALPHA)) {
            this.colorMatte = Color.BLACK;
        }
    }

    @JSONHint(ignore=true)
    public boolean isAvailable() {
        return !this.availableOptions.isEmpty();
    }

    public boolean isAvailable(Option option) {
        return this.availableOptions.contains((Object)option);
    }

    public AlphaType getAlphaType() {
        return this.alphaType;
    }

    public void setAlphaType(AlphaType alphaType) {
        this.alphaType = alphaType;
    }

    public Color getColorMatte() {
        return this.colorMatte;
    }

    public void setColorMatte(Color colorMatte) {
        this.colorMatte = colorMatte;
    }

    public Time getVideoFrameDuration() {
        return this.videoFrameDuration;
    }

    public void setVideoFrameDuration(Time videoFrameDuration) {
        this.videoFrameDuration = videoFrameDuration;
    }

    public Time getDuration() {
        return this.duration;
    }

    public void setDuration(Time duration) {
        this.duration = duration;
    }

    public Size2i getSize() {
        return this.size;
    }

    public void setSize(Size2i size) {
        this.size = size;
    }

    public boolean isFlipVertical() {
        return this.flipVertical;
    }

    public void setFlipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
    }

    public MediaOptions clone() {
        try {
            MediaOptions clone = (MediaOptions)super.clone();
            clone.availableOptions = this.availableOptions.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.alphaType == null ? 0 : this.alphaType.hashCode());
        result = 31 * result + (this.availableOptions == null ? 0 : this.availableOptions.hashCode());
        result = 31 * result + (this.colorMatte == null ? 0 : this.colorMatte.hashCode());
        result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
        result = 31 * result + (this.flipVertical ? 1231 : 1237);
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.videoFrameDuration == null ? 0 : this.videoFrameDuration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaOptions other = (MediaOptions)obj;
        if (this.alphaType == null ? other.alphaType != null : !this.alphaType.equals((Object)other.alphaType)) {
            return false;
        }
        if (this.availableOptions == null ? other.availableOptions != null : !this.availableOptions.equals(other.availableOptions)) {
            return false;
        }
        if (this.colorMatte == null ? other.colorMatte != null : !this.colorMatte.equals((Object)other.colorMatte)) {
            return false;
        }
        if (this.duration == null ? other.duration != null : !this.duration.equals((Object)other.duration)) {
            return false;
        }
        if (this.flipVertical != other.flipVertical) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals((Object)other.size)) {
            return false;
        }
        return !(this.videoFrameDuration == null ? other.videoFrameDuration != null : !this.videoFrameDuration.equals((Object)other.videoFrameDuration));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlphaType {
        IGNORE,
        STRAIGHT,
        PREMULTIPLIED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        IGNORE_ALPHA,
        STRAIGHT_ALPHA,
        PREMULTIPLIED_ALPHA,
        VIDEO_FRAME_DURATION,
        DURATION,
        SIZE,
        FLIP_VERTICAL;

    }
}

