/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.util.EventObject;
import org.eclipse.equinox.internal.p2.ui.BatchChangeBeginningEvent;
import org.eclipse.equinox.internal.p2.ui.BatchChangeCompleteEvent;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.engine.ProfileEvent;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;

public abstract class ProvUIProvisioningListener
implements ProvisioningListener {
    public static final int PROV_EVENT_METADATA_REPOSITORY = 1;
    public static final int PROV_EVENT_IU = 2;
    public static final int PROV_EVENT_PROFILE = 4;
    public static final int PROV_EVENT_ARTIFACT_REPOSITORY = 8;
    int eventTypes = 0;
    int batchCount = 0;

    public ProvUIProvisioningListener(int eventTypes) {
        this.eventTypes = eventTypes;
    }

    public void notify(EventObject o) {
        if (o instanceof BatchChangeBeginningEvent) {
            ++this.batchCount;
        } else if (o instanceof BatchChangeCompleteEvent) {
            --this.batchCount;
            if (this.batchCount <= 0 && ((BatchChangeCompleteEvent)o).notify) {
                this.refreshAll();
            }
        } else {
            RepositoryEvent event;
            if (this.batchCount > 0) {
                return;
            }
            if (o instanceof ProfileEvent && ((this.eventTypes & 2) == 2 || (this.eventTypes & 4) == 4)) {
                ProfileEvent event2 = (ProfileEvent)o;
                if (event2.getReason() == 2) {
                    this.profileChanged(event2.getProfileId());
                } else if (event2.getReason() == 0) {
                    this.profileAdded(event2.getProfileId());
                } else if (event2.getReason() == 1) {
                    this.profileRemoved(event2.getProfileId());
                }
            } else if (o instanceof RepositoryEvent && ((event = (RepositoryEvent)o).getRepositoryType() == 0 && (this.eventTypes & 1) == 1 || event.getRepositoryType() == 1 && (this.eventTypes & 8) == 8)) {
                if (event.getKind() == 0) {
                    this.repositoryAdded(event);
                } else if (event.getKind() == 1) {
                    this.repositoryRemoved(event);
                } else if (event.getKind() == 4) {
                    this.repositoryDiscovered(event);
                } else if (event.getKind() == 2) {
                    this.repositoryChanged(event);
                } else if (event.getKind() == 8) {
                    this.repositoryEnablement(event);
                }
            }
        }
    }

    protected void repositoryAdded(RepositoryEvent event) {
    }

    protected void repositoryRemoved(RepositoryEvent event) {
    }

    protected void repositoryDiscovered(RepositoryEvent event) {
    }

    protected void repositoryChanged(RepositoryEvent event) {
    }

    protected void repositoryEnablement(RepositoryEvent event) {
        if (event.isRepositoryEnabled()) {
            this.repositoryAdded(event);
        } else {
            this.repositoryRemoved(event);
        }
    }

    protected void profileChanged(String profileId) {
    }

    protected void profileAdded(String profileId) {
    }

    protected void profileRemoved(String profileId) {
    }

    protected void refreshAll() {
    }

    public int getEventTypes() {
        return this.eventTypes;
    }
}

