/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.windows.wgl;

import com.jogamp.nativewindow.impl.ProxySurface;
import com.jogamp.nativewindow.impl.windows.GDI;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLContext;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLDrawable;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLGraphicsConfiguration;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class WindowsDummyWGLDrawable
extends WindowsWGLDrawable {
    private static final int f_dim = 64;
    private long hwnd = GDI.CreateDummyWindow((int)0, (int)0, (int)64, (int)64);
    private long hdc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WindowsDummyWGLDrawable(GLDrawableFactory gLDrawableFactory, GLCapabilitiesImmutable gLCapabilitiesImmutable, AbstractGraphicsScreen abstractGraphicsScreen) {
        super(gLDrawableFactory, (NativeSurface)new ProxySurface((AbstractGraphicsConfiguration)WindowsWGLGraphicsConfigurationFactory.createDefaultGraphicsConfiguration(gLCapabilitiesImmutable, abstractGraphicsScreen)), true);
        if (0L == this.hwnd) {
            throw new GLException("Error hwnd 0, werr: " + GDI.GetLastError());
        }
        ProxySurface proxySurface = (ProxySurface)this.getNativeSurface();
        proxySurface.setSize(64, 64);
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)proxySurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = windowsWGLGraphicsConfiguration.getScreen().getDevice();
        abstractGraphicsDevice.lock();
        try {
            if (1 >= proxySurface.lockSurface()) {
                throw new GLException("WindowsDummyWGLDrawable: surface not ready (lockSurface)");
            }
            try {
                this.hdc = GDI.GetDC((long)this.hwnd);
                if (0L == this.hdc) {
                    throw new GLException("Error hdc 0, werr: " + GDI.GetLastError());
                }
                proxySurface.setSurfaceHandle(this.hdc);
                windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(gLDrawableFactory, (NativeSurface)proxySurface, null);
                if (DEBUG) {
                    System.err.println("!!! WindowsDummyWGLDrawable: hdc " + WindowsDummyWGLDrawable.toHexString(this.hdc) + ", " + windowsWGLGraphicsConfiguration);
                }
            }
            catch (Throwable throwable) {
                this.destroyImpl();
                throw new GLException(throwable);
            }
            finally {
                proxySurface.unlockSurface();
            }
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    public static WindowsDummyWGLDrawable create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile, AbstractGraphicsScreen abstractGraphicsScreen) {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDepthBits(16);
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setOnscreen(true);
        gLCapabilities.setPBuffer(true);
        return new WindowsDummyWGLDrawable(gLDrawableFactory, gLCapabilities, abstractGraphicsScreen);
    }

    public void setSize(int n, int n2) {
    }

    public int getWidth() {
        return 1;
    }

    public int getHeight() {
        return 1;
    }

    public GLContext createContext(GLContext gLContext) {
        return new WindowsWGLContext(this, gLContext);
    }

    protected void destroyImpl() {
        if (this.hdc != 0L) {
            GDI.ReleaseDC((long)this.hwnd, (long)this.hdc);
            this.hdc = 0L;
            ProxySurface proxySurface = (ProxySurface)this.getNativeSurface();
            proxySurface.setSurfaceHandle(this.hdc);
        }
        if (this.hwnd != 0L) {
            GDI.ShowWindow((long)this.hwnd, (int)0);
            GDI.DestroyWindow((long)this.hwnd);
            this.hwnd = 0L;
        }
    }
}

