/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.runtime.opengl;

public class GLExtensionNames {
    public static final String[] extensionsARB = new String[]{"ARB", "GL2", "OES", "KHR", "OML"};
    public static final String[] extensionsVEN = new String[]{"3DFX", "AMD", "ANGLE", "ARM", "APPLE", "ATI", "EXT", "HI", "HP", "IBM", "IMG", "MESA", "MESAX", "NV", "QCOM", "SGI", "SGIS", "SGIX", "SUN", "VIV", "WIN"};

    public static final boolean isGLFunction(String string) {
        return string.startsWith("gl") || string.startsWith("egl") || string.startsWith("wgl") || string.startsWith("agl") || string.startsWith("cgl");
    }

    public static final boolean isGLEnumeration(String string) {
        return string.startsWith("GL_") || string.startsWith("GLU_") || string.startsWith("GLX_") || string.startsWith("EGL_") || string.startsWith("WGL_") || string.startsWith("AGL_") || string.startsWith("CGL_");
    }

    public static final int getExtensionIdx(String[] stringArray, String string, boolean bl) {
        if (bl) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!string.endsWith(stringArray[i])) continue;
                return i;
            }
        } else {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!string.endsWith("_" + stringArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static final boolean isExtension(String[] stringArray, String string, boolean bl) {
        return GLExtensionNames.getExtensionIdx(stringArray, string, bl) >= 0;
    }

    public static final String getExtensionSuffix(String string, boolean bl) {
        int n = GLExtensionNames.getExtensionIdx(extensionsARB, string, bl);
        if (n >= 0) {
            return extensionsARB[n];
        }
        n = GLExtensionNames.getExtensionIdx(extensionsVEN, string, bl);
        if (n >= 0) {
            return extensionsVEN[n];
        }
        return null;
    }

    public static final String normalize(String[] stringArray, String string, boolean bl) {
        boolean bl2 = false;
        for (int i = stringArray.length - 1; !bl2 && i >= 0; --i) {
            if (bl) {
                if (!string.endsWith(stringArray[i])) continue;
                string = string.substring(0, string.length() - stringArray[i].length());
                bl2 = true;
                continue;
            }
            if (!string.endsWith("_" + stringArray[i])) continue;
            string = string.substring(0, string.length() - 1 - stringArray[i].length());
            bl2 = true;
        }
        return string;
    }

    public static final String normalizeARB(String string, boolean bl) {
        return GLExtensionNames.normalize(extensionsARB, string, bl);
    }

    public static final boolean isExtensionARB(String string, boolean bl) {
        return GLExtensionNames.isExtension(extensionsARB, string, bl);
    }

    public static final String normalizeVEN(String string, boolean bl) {
        return GLExtensionNames.normalize(extensionsVEN, string, bl);
    }

    public static final boolean isExtensionVEN(String string, boolean bl) {
        return GLExtensionNames.isExtension(extensionsVEN, string, bl);
    }

    public static final String normalize(String string, boolean bl) {
        if (GLExtensionNames.isExtensionARB(string, bl)) {
            return GLExtensionNames.normalizeARB(string, bl);
        }
        if (GLExtensionNames.isExtensionVEN(string, bl)) {
            return GLExtensionNames.normalizeVEN(string, bl);
        }
        return string;
    }

    public static final boolean isExtension(String string, boolean bl) {
        return GLExtensionNames.isExtension(extensionsARB, string, bl) || GLExtensionNames.isExtension(extensionsVEN, string, bl);
    }

    public static final int getFuncNamePermutationNumber(String string) {
        if (GLExtensionNames.isExtensionARB(string, true) || GLExtensionNames.isExtensionVEN(string, true)) {
            return 1;
        }
        return 1 + extensionsARB.length + extensionsVEN.length;
    }

    public static final String getFuncNamePermutation(String string, int n) {
        if (n == 0) {
            return string;
        }
        if (0 > n || n >= 1 + extensionsARB.length + extensionsVEN.length) {
            throw new RuntimeException("Index out of range [0.." + (1 + extensionsARB.length + extensionsVEN.length - 1) + "]: " + n);
        }
        if (--n < extensionsARB.length) {
            return string + extensionsARB[n];
        }
        return string + extensionsVEN[n -= extensionsARB.length];
    }
}

