/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.equinox.p2.publisher.actions.MergeResultsAction;
import org.eclipse.equinox.p2.publisher.actions.RootFilesAction;
import org.eclipse.equinox.p2.publisher.actions.RootFilesAdvice;
import org.eclipse.equinox.p2.publisher.actions.RootIUAction;
import org.eclipse.equinox.p2.publisher.actions.RootIUAdvice;
import org.eclipse.equinox.p2.publisher.actions.RootIUResultFilterAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.AccumulateConfigDataAction;
import org.eclipse.equinox.p2.publisher.eclipse.ApplicationLauncherAction;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigCUsAction;
import org.eclipse.equinox.p2.publisher.eclipse.DefaultCUsAction;
import org.eclipse.equinox.p2.publisher.eclipse.EquinoxExecutableAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;

public class EclipseInstallAction
extends AbstractPublisherAction {
    protected String source;
    protected String id;
    protected Version version;
    protected String name;
    protected String executableName;
    protected String flavor;
    protected VersionedName[] topLevel;
    protected String[] nonRootFiles;
    protected boolean start = false;
    static /* synthetic */ Class class$0;

    protected EclipseInstallAction() {
    }

    public EclipseInstallAction(String source, String id, Version version, String name, String executableName, String flavor, VersionedName[] topLevel, String[] nonRootFiles, boolean start) {
        this.source = source;
        this.id = id;
        this.version = version;
        this.name = name == null ? id : name;
        this.executableName = executableName == null ? "eclipse" : executableName;
        this.flavor = flavor;
        this.topLevel = topLevel;
        this.nonRootFiles = nonRootFiles;
        this.start = start;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        monitor = SubMonitor.convert((IProgressMonitor)monitor);
        this.info = info;
        IPublisherAction[] actions = this.createActions();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.EclipseInstallAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MultiStatus finalStatus = new MultiStatus(clazz.getName(), 0, "publishing result", null);
        int i = 0;
        while (i < actions.length) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            finalStatus.merge(actions[i].perform(info, results, monitor));
            ++i;
        }
        if (!finalStatus.isOK()) {
            return finalStatus;
        }
        return Status.OK_STATUS;
    }

    protected IPublisherAction[] createActions() {
        this.createAdvice();
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>();
        MergeResultsAction action = new MergeResultsAction(new IPublisherAction[]{this.createFeaturesAction(), this.createBundlesAction()}, 2);
        actions.add(action);
        actions.add(this.createApplicationExecutableAction(this.info.getConfigurations()));
        actions.add(this.createRootFilesAction());
        actions.addAll(this.createAccumulateConfigDataActions(this.info.getConfigurations()));
        actions.add(this.createJREAction());
        actions.add(this.createConfigCUsAction());
        actions.add(this.createDefaultCUsAction());
        actions.add(this.createRootIUAction());
        return actions.toArray(new IPublisherAction[actions.size()]);
    }

    private void createAdvice() {
        this.createRootFilesAdvice();
        this.createRootAdvice();
    }

    protected void createRootAdvice() {
        if (this.topLevel != null) {
            this.info.addAdvice(new RootIUAdvice(this.getTopLevel()));
        }
        this.info.addAdvice(new RootIUResultFilterAdvice(null));
    }

    protected IPublisherAction createDefaultCUsAction() {
        return new DefaultCUsAction(this.info, this.flavor, 4, this.start);
    }

    protected IPublisherAction createRootIUAction() {
        return new RootIUAction(this.id, this.version, this.name);
    }

    protected Collection getTopLevel() {
        return Arrays.asList(this.topLevel);
    }

    protected IPublisherAction createJREAction() {
        return new JREAction(null);
    }

    protected IPublisherAction createApplicationExecutableAction(String[] configSpecs) {
        return new ApplicationLauncherAction(this.id, this.version, this.flavor, this.executableName, this.getExecutablesLocation(), configSpecs);
    }

    protected Collection createAccumulateConfigDataActions(String[] configs) {
        ArrayList<AccumulateConfigDataAction> result = new ArrayList<AccumulateConfigDataAction>(configs.length);
        int i = 0;
        while (i < configs.length) {
            String os;
            File executable;
            String configSpec = configs[i];
            File configuration = this.computeConfigurationLocation(configSpec);
            if (!configuration.exists()) {
                configuration = null;
            }
            if (!(executable = ExecutablesDescriptor.findExecutable(os = AbstractPublisherAction.parseConfigSpec(configSpec)[1], this.computeExecutableLocation(configSpec), "eclipse")).exists()) {
                executable = null;
            }
            AccumulateConfigDataAction action = new AccumulateConfigDataAction(this.info, configSpec, configuration, executable);
            result.add(action);
            ++i;
        }
        return result;
    }

    protected IPublisherAction createConfigCUsAction() {
        return new ConfigCUsAction(this.info, this.flavor, this.id, this.version);
    }

    protected IPublisherAction createFeaturesAction() {
        return new FeaturesAction(new File[]{new File(this.source, "features")});
    }

    protected Collection createExecutablesActions(String[] configSpecs) {
        ArrayList<EquinoxExecutableAction> result = new ArrayList<EquinoxExecutableAction>(configSpecs.length);
        int i = 0;
        while (i < configSpecs.length) {
            ExecutablesDescriptor executables = this.computeExecutables(configSpecs[i]);
            EquinoxExecutableAction action = new EquinoxExecutableAction(executables, configSpecs[i], this.id, this.version, this.flavor);
            result.add(action);
            ++i;
        }
        return result;
    }

    protected IPublisherAction createRootFilesAction() {
        return new RootFilesAction(this.info, this.id, this.version, this.flavor);
    }

    protected void createRootFilesAdvice() {
        File[] baseExclusions = this.computeRootFileExclusions();
        if (baseExclusions != null) {
            this.info.addAdvice(new RootFilesAdvice(null, null, baseExclusions, null));
        }
        String[] configs = this.info.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            this.info.addAdvice(this.computeRootFileAdvice(configs[i]));
            ++i;
        }
    }

    protected IPublisherAdvice computeRootFileAdvice(String configSpec) {
        File root = this.computeRootFileRoot(configSpec);
        File[] inclusions = this.computeRootFileInclusions(configSpec);
        File[] exclusions = this.computeRootFileExclusions(configSpec);
        return new RootFilesAdvice(root, inclusions, exclusions, configSpec);
    }

    protected File[] computeRootFileExclusions(String configSpec) {
        ExecutablesDescriptor executables = this.computeExecutables(configSpec);
        File[] files = executables.getFiles();
        File[] result = new File[files.length + 1];
        System.arraycopy(files, 0, result, 0, files.length);
        result[files.length] = executables.getIniLocation();
        return result;
    }

    protected File[] computeRootFileExclusions() {
        if (this.nonRootFiles == null || this.nonRootFiles.length == 0) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        int i = 0;
        while (i < this.nonRootFiles.length) {
            String filename = this.nonRootFiles[i];
            File file = new File(filename);
            if (file.isAbsolute()) {
                result.add(file);
            } else {
                result.add(new File(this.source, filename));
            }
            ++i;
        }
        return result.toArray(new File[result.size()]);
    }

    protected ExecutablesDescriptor computeExecutables(String configSpec) {
        String os = AbstractPublisherAction.parseConfigSpec(configSpec)[1];
        return ExecutablesDescriptor.createDescriptor(os, "eclipse", this.computeExecutableLocation(configSpec));
    }

    protected File computeRootFileRoot(String configSpec) {
        return new File(this.source);
    }

    protected File[] computeRootFileInclusions(String configSpec) {
        return new File[]{new File(this.source)};
    }

    protected File computeExecutableLocation(String configSpec) {
        return new File(this.source);
    }

    protected File getExecutablesLocation() {
        return new File(this.source);
    }

    protected File computeConfigurationLocation(String configSpec) {
        return new File(this.source, "configuration/config.ini");
    }

    protected IPublisherAction createBundlesAction() {
        return new BundlesAction(new File[]{new File(this.source, "plugins")});
    }
}

