package trail.slsb;

import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.RemoteBinding;

import javax.ejb.*;

@Stateless
@Local ({Calculator.class})
@LocalBinding (jndiBinding="EJB3Trail/LocalCalculator")
@Remote ({RemoteCalculator.class})
@RemoteBinding (jndiBinding="EJB3Trail/RemoteCalculator")
public class LocalRemoteCalculator implements Calculator, RemoteCalculator {

  public double calculate (int start, int end, double growthrate, double saving) {
    double tmp = Math.pow(1. + growthrate / 12., 12. * (end - start) + 1);
    return saving * 12. * (tmp - 1) / growthrate;
  }

  public String getServerInfo () {
    return "This is the JBoss EJB 3.0 Trail Blazer";
  }

}