/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import javax.persistence.PersistenceContextType;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.engine.SessionImplementor;

public class EntityManagerImpl
extends AbstractEntityManagerImpl {
    protected Session session;
    protected SessionFactory sessionFactory;
    protected boolean open;

    public EntityManagerImpl(SessionFactory sessionFactory, PersistenceContextType pcType, PersistenceUnitTransactionType transactionType) {
        super(pcType, transactionType);
        this.sessionFactory = sessionFactory;
        this.open = true;
    }

    public Session getSession() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        if (this.session == null) {
            this.session = this.sessionFactory.openSession();
            if (this.persistenceContextType == PersistenceContextType.TRANSACTION) {
                ((SessionImplementor)this.session).setAutoClear(true);
            }
        }
        return this.session;
    }

    public void close() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        this.open = false;
        if (this.session != null) {
            this.session.close();
        }
    }

    public boolean isOpen() {
        this.adjustFlushMode();
        if (this.open) {
            this.getSession().isOpen();
        }
        return this.open;
    }
}

