/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.javasource;

import de.java2html.javasource.JavaSourceIterator;
import de.java2html.javasource.JavaSourceStatistic;
import de.java2html.javasource.JavaSourceType;

public class JavaSource {
    private String source;
    private JavaSourceType[] types;
    private JavaSourceStatistic statistic;

    public JavaSource(String source) {
        this.source = source;
        this.statistic = new JavaSourceStatistic();
    }

    public JavaSourceType[] getClassification() {
        return this.types;
    }

    public void setClassification(JavaSourceType[] types) {
        this.types = types;
    }

    public String getCode() {
        return this.source;
    }

    public void print() {
        System.out.println("------------------------------");
        int start = 0;
        int end = 0;
        while (start < this.types.length) {
            while (end < this.types.length - 1 && this.types[end + 1] == this.types[start]) {
                ++end;
            }
            this.print(start, end);
            end = start = end + 1;
        }
    }

    protected void print(int start, int end) {
        System.out.print(this.types[start] + ": ");
        System.out.println("@" + this.source.substring(start, end + 1).replace('\n', '#') + "@");
    }

    public String getStatisticsString() {
        return this.statistic.getScreenString("\n");
    }

    public String getFileName() {
        return this.getStatistic().getFileName();
    }

    public void setFileName(String fileName) {
        this.getStatistic().setFileName(fileName);
    }

    public int getLineCount() {
        return this.statistic.getLineCount();
    }

    public int getMaxLineLength() {
        return this.statistic.getMaxLineLength();
    }

    public JavaSourceStatistic getStatistic() {
        return this.statistic;
    }

    public JavaSourceIterator getIterator() {
        return new JavaSourceIterator(this);
    }
}

