/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter;

import de.java2html.converter.ConverterMetaData;
import de.java2html.converter.IJavaSourceConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.util.Ensure;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractJavaSourceConverter
implements IJavaSourceConverter {
    private final ConverterMetaData metaData;

    public AbstractJavaSourceConverter(ConverterMetaData metaData) {
        Ensure.ensureArgumentNotNull(metaData);
        this.metaData = metaData;
    }

    public final void convert(JavaSource source, JavaSourceConversionOptions options, Writer writer) throws IOException {
        BufferedWriter bw = null;
        bw = new BufferedWriter(writer);
        this.convert(source, options, bw);
        bw.flush();
    }

    public abstract void convert(JavaSource var1, JavaSourceConversionOptions var2, BufferedWriter var3) throws IOException;

    public abstract String getDocumentHeader(JavaSourceConversionOptions var1, String var2);

    public abstract String getDocumentFooter(JavaSourceConversionOptions var1);

    public abstract String getBlockSeparator(JavaSourceConversionOptions var1);

    public void writeDocumentHeader(Writer writer, JavaSourceConversionOptions options, String title) throws IOException {
        writer.write(this.getDocumentHeader(options, title));
    }

    public void writeDocumentFooter(Writer writer, JavaSourceConversionOptions options) throws IOException {
        writer.write(this.getDocumentFooter(options));
    }

    public void writeBlockSeparator(Writer writer, JavaSourceConversionOptions options) throws IOException {
        writer.write(this.getBlockSeparator(options));
    }

    public final String getDefaultFileExtension() {
        return this.metaData.getDefaultFileExtension();
    }

    public final ConverterMetaData getMetaData() {
        return this.metaData;
    }
}

