/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.commandline;

import de.java2html.commandline.AbstractJava2HtmlConversion;
import de.java2html.converter.IJavaSourceConverter;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.util.Ensure;
import de.java2html.util.IoUtilities;
import java.io.File;
import java.io.IOException;

public class Java2HtmlDirectoryConversion
extends AbstractJava2HtmlConversion {
    private final File sourceDirectory;
    private final File targetDirectory;
    private final String fileMask;
    private final boolean copyUnprocessedFiles;

    public Java2HtmlDirectoryConversion(File sourceDirectory, IJavaSourceConverter converter, File targetDirectory, String fileMask, boolean copyUnprocessedFiles, JavaSourceConversionOptions options) {
        super(converter, options);
        Ensure.ensureArgumentNotNull(fileMask);
        Ensure.ensureArgumentNotNull(sourceDirectory);
        this.sourceDirectory = sourceDirectory;
        if (targetDirectory == null) {
            targetDirectory = sourceDirectory;
        }
        this.targetDirectory = targetDirectory;
        this.fileMask = fileMask;
        this.copyUnprocessedFiles = copyUnprocessedFiles;
    }

    public void execute() {
        this.convertDirectory(this.sourceDirectory, this.targetDirectory);
    }

    private void convertDirectory(File sourceDirectory, File targetDirectory) {
        File[] files = sourceDirectory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File targetFile;
            File file = files[i];
            if (file.isDirectory()) {
                File newTargetDirectory = null;
                newTargetDirectory = sourceDirectory.equals(targetDirectory) ? file : new File(targetDirectory, file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length()));
                this.convertDirectory(file, newTargetDirectory);
                continue;
            }
            if (this.matches(file)) {
                targetFile = null;
                targetFile = sourceDirectory.equals(targetDirectory) ? file : new File(targetDirectory, file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length()));
                targetFile = IoUtilities.exchangeFileExtension(targetFile, this.getConverter().getMetaData().getDefaultFileExtension());
                this.convertFile(file, targetFile);
                continue;
            }
            if (!this.copyUnprocessedFiles || sourceDirectory.equals(targetDirectory)) continue;
            targetFile = new File(targetDirectory, file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length()));
            try {
                IoUtilities.copy(file, targetFile);
                continue;
            }
            catch (IOException e) {
                System.err.println("ERROR: Could cot copy file to target:  " + file.getAbsolutePath());
            }
        }
    }

    private boolean matches(File file) {
        return file.getAbsolutePath().toLowerCase().endsWith(this.fileMask.substring(1));
    }
}

