/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache;

import java.util.HashMap;
import javax.ejb.EJBException;
import javax.ejb.EJBNoSuchObjectException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.util.id.GUID;

public class NoPassivationCache
implements StatefulCache {
    private Pool pool;
    private HashMap cacheMap;

    public void initialize(Container container) throws Exception {
        this.pool = container.getPool();
        this.cacheMap = new HashMap();
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            this.cacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext create() {
        StatefulBeanContext ctx = null;
        try {
            GUID guid = new GUID();
            ctx = (StatefulBeanContext)this.pool.get();
            ctx.setId(guid);
            HashMap hashMap = this.cacheMap;
            synchronized (hashMap) {
                this.cacheMap.put(guid, ctx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException(e);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext create(Class[] initTypes, Object[] initValues) {
        StatefulBeanContext ctx = null;
        try {
            GUID guid = new GUID();
            ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
            ctx.setId(guid);
            HashMap hashMap = this.cacheMap;
            synchronized (hashMap) {
                this.cacheMap.put(guid, ctx);
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext get(Object key) throws EJBException {
        StatefulBeanContext entry = null;
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            entry = (StatefulBeanContext)this.cacheMap.get(key);
        }
        if (entry == null) {
            throw new EJBNoSuchObjectException("Could not find Stateful bean: " + key);
        }
        entry.inUse = true;
        entry.lastUsed = System.currentTimeMillis();
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.inUse = false;
            ctx.lastUsed = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        StatefulBeanContext ctx = null;
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            ctx = (StatefulBeanContext)this.cacheMap.remove(key);
        }
        if (ctx != null) {
            this.pool.remove(ctx);
        }
    }
}

