/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.callback;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class MethodHashing {
    static Map hashMap = new WeakHashMap();

    public static Method findMethodByHash(Class clazz, long hash) throws Exception {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (MethodHashing.methodHash(methods[i]) != hash) continue;
            return methods[i];
        }
        if (clazz.isInterface()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            int numInterfaces = interfaces.length;
            for (int count = 0; count < numInterfaces; ++count) {
                Method method = MethodHashing.findMethodByHash(interfaces[count], hash);
                if (method == null) continue;
                return method;
            }
        } else if (clazz.getSuperclass() != null) {
            return MethodHashing.findMethodByHash(clazz.getSuperclass(), hash);
        }
        return null;
    }

    public static Constructor findConstructorByHash(Class clazz, long hash) throws Exception {
        Constructor<?>[] cons = clazz.getDeclaredConstructors();
        for (int i = 0; i < cons.length; ++i) {
            if (MethodHashing.constructorHash(cons[i]) != hash) continue;
            return cons[i];
        }
        if (clazz.getSuperclass() != null) {
            return MethodHashing.findConstructorByHash(clazz.getSuperclass(), hash);
        }
        return null;
    }

    public static long methodHash(Method method) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        String methodDesc = method.getName() + "(";
        for (int j = 0; j < parameterTypes.length; ++j) {
            methodDesc = methodDesc + MethodHashing.getTypeString(parameterTypes[j]);
        }
        methodDesc = methodDesc + ")" + MethodHashing.getTypeString(method.getReturnType());
        return MethodHashing.createHash(methodDesc);
    }

    public static long createHash(String methodDesc) throws Exception {
        long hash = 0L;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
        MessageDigest messagedigest = MessageDigest.getInstance("SHA");
        DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
        dataoutputstream.writeUTF(methodDesc);
        dataoutputstream.flush();
        byte[] abyte0 = messagedigest.digest();
        for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
            hash += (long)(abyte0[j] & 0xFF) << j * 8;
        }
        return hash;
    }

    public static long constructorHash(Constructor method) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        String methodDesc = method.getName() + "(";
        for (int j = 0; j < parameterTypes.length; ++j) {
            methodDesc = methodDesc + MethodHashing.getTypeString(parameterTypes[j]);
        }
        methodDesc = methodDesc + ")";
        long hash = 0L;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
        MessageDigest messagedigest = MessageDigest.getInstance("SHA");
        DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
        dataoutputstream.writeUTF(methodDesc);
        dataoutputstream.flush();
        byte[] abyte0 = messagedigest.digest();
        for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
            hash += (long)(abyte0[j] & 0xFF) << j * 8;
        }
        return hash;
    }

    public static Map getInterfaceHashes(Class intf) {
        Method[] methods = intf.getDeclaredMethods();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            try {
                long hash = MethodHashing.methodHash(method);
                map.put(method.toString(), new Long(hash));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return map;
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + MethodHashing.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    public static long calculateHash(Method method) {
        Map methodHashes = (Map)hashMap.get(method.getDeclaringClass());
        if (methodHashes == null) {
            methodHashes = MethodHashing.getInterfaceHashes(method.getDeclaringClass());
            WeakHashMap newHashMap = new WeakHashMap();
            newHashMap.putAll(hashMap);
            newHashMap.put(method.getDeclaringClass(), methodHashes);
            hashMap = newHashMap;
        }
        return (Long)methodHashes.get(method.toString());
    }
}

