/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import javax.persistence.FlushModeType;
import javax.persistence.TemporalType;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Query;

public class QueryImpl
implements javax.persistence.Query {
    private Query query;

    public QueryImpl(Query query) {
        this.query = query;
    }

    public Query getHibernateQuery() {
        return this.query;
    }

    public int executeUpdate() {
        return this.query.executeUpdate();
    }

    public List getResultList() {
        return this.query.list();
    }

    public Object getSingleResult() {
        try {
            Object result = this.query.uniqueResult();
            if (result == null) {
                throw new EntityNotFoundException("No entity found for query");
            }
            return result;
        }
        catch (NonUniqueResultException e) {
            throw new javax.persistence.NonUniqueResultException(e.getMessage());
        }
    }

    public javax.persistence.Query setMaxResults(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException("Negative (" + maxResult + ") parameter passed in to setMaxResults");
        }
        this.query.setMaxResults(maxResult);
        return this;
    }

    public javax.persistence.Query setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative (" + firstResult + ") parameter passed in to setMaxResults");
        }
        this.query.setFirstResult(firstResult);
        return this;
    }

    public javax.persistence.Query setHint(String hintName, Object value) {
        try {
            if ("org.hibernate.timeout".equals(hintName)) {
                this.query.setTimeout(((Integer)value).intValue());
            } else if ("org.hibernate.comment".equals(hintName)) {
                this.query.setComment((String)value);
            } else if ("org.hibernate.fetchSize".equals(hintName)) {
                this.query.setFetchSize(((Integer)value).intValue());
            } else if ("org.hibernate.cacheRegion".equals(hintName)) {
                this.query.setCacheRegion((String)value);
            } else if ("org.hibernate.cacheable".equals(hintName)) {
                this.query.setCacheable(((Boolean)value).booleanValue());
            } else if ("org.hibernate.readOnly".equals(hintName)) {
                this.query.setReadOnly(((Boolean)value).booleanValue());
            } else if ("org.hibernate.cacheMode".equals(hintName)) {
                this.query.setCacheMode((CacheMode)value);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value for hint");
        }
        return this;
    }

    public javax.persistence.Query setParameter(String name, Object value) {
        this.query.setParameter(name, value);
        return this;
    }

    public javax.persistence.Query setParameter(String name, Date value, TemporalType temporalType) {
        if (temporalType == TemporalType.DATE) {
            this.query.setDate(name, value);
        } else if (temporalType == TemporalType.TIME) {
            this.query.setTime(name, value);
        } else if (temporalType == TemporalType.TIMESTAMP) {
            this.query.setTimestamp(name, value);
        }
        return this;
    }

    public javax.persistence.Query setParameter(String name, Calendar value, TemporalType temporalType) {
        if (temporalType == TemporalType.DATE) {
            this.query.setCalendarDate(name, value);
        } else {
            if (temporalType == TemporalType.TIME) {
                throw new IllegalArgumentException("not yet implemented");
            }
            if (temporalType == TemporalType.TIMESTAMP) {
                this.query.setCalendar(name, value);
            }
        }
        return this;
    }

    public javax.persistence.Query setParameter(int position, Object value) {
        this.query.setParameter(position, value);
        return this;
    }

    public javax.persistence.Query setParameter(int position, Date value, TemporalType temporalType) {
        if (temporalType == TemporalType.DATE) {
            this.query.setDate(position, value);
        } else if (temporalType == TemporalType.TIME) {
            this.query.setTime(position, value);
        } else if (temporalType == TemporalType.TIMESTAMP) {
            this.query.setTimestamp(position, value);
        }
        return this;
    }

    public javax.persistence.Query setParameter(int position, Calendar value, TemporalType temporalType) {
        if (temporalType == TemporalType.DATE) {
            this.query.setCalendarDate(position, value);
        } else {
            if (temporalType == TemporalType.TIME) {
                throw new IllegalArgumentException("not yet implemented");
            }
            if (temporalType == TemporalType.TIMESTAMP) {
                this.query.setCalendar(position, value);
            }
        }
        return this;
    }

    public javax.persistence.Query setFlushMode(FlushModeType flushMode) {
        if (flushMode == FlushModeType.AUTO) {
            this.query.setFlushMode(FlushMode.AUTO);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.query.setFlushMode(FlushMode.COMMIT);
        } else if (flushMode == FlushModeType.NEVER) {
            this.query.setFlushMode(FlushMode.NEVER);
        }
        return this;
    }
}

