/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef STOPWATCH_H
#define STOPWATCH_H

#include <time.h>

#define GET_SEC(time)   time % 60
#define GET_MIN(time)   time / 60
#define GET_HOUR(time)  time / 3600
#define TIME_TO_SEC(h,m,s) (h*3600+m*60+s)
  
class CStopWatch{

 public:
  CStopWatch();
  void start();
  void stop();
  void getClearTime(int *hour, int *min, int *sec);
  int getClearTime();

 private:
  time_t m_starttime; /* start time */
  time_t m_cleartime; /* clear time */
};

#endif
