#!/bin/sh

if [ "$1" = "sl700" ]; then
    ln -v -f -s config/config-sl700.h config.h
    ln -v -f -s config/config.mk-sl700 config.mk
    ln -v -f -s bigFishSize.h areaSize.h
    ln -v -f -s HiScoreRegConfig-sl700.h HiScoreRegConfig.h
    DESKTOP_FILE=qfish-sl700.desktop
elif [ "$1" = "sl300" ]; then
    ln -v -f -s config/config-sl300.h config.h
    ln -v -f -s config/config.mk-sl300 config.mk
    ln -v -f -s smallFishSize.h areaSize.h
    ln -v -f -s HiScoreRegConfig-sl300.h HiScoreRegConfig.h
    DESKTOP_FILE=qfish-sl300.desktop
else
    echo "usage: $0 sl700 | sl300 cross | native"
    exit 1
fi

if [ "$2" = "cross" ]; then
    export CROSSCOMPILE=/opt/Embedix/tools
    export QPEDIR=/opt/Qtopia/sharp
    export QTDIR=/opt/Qtopia/sharp
    export PATH=$QTDIR/bin:$QPEDIR/bin:$CROSSCOMPILE/bin:$PATH
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-sharp-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
elif [ "$2" = "native" ]; then
    export CROSSCOMPILE=
    export QPEDIR=/opt/Qtopia
    export QTDIR=/opt/Qtopia
    export PATH=$QTDIR/bin:$QPEDIR/bin:$PATH:/opt/Embedix/tools/bin
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-x86-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
else
    echo "usage: $0 sl700 | sl300 cross | native"
    exit 1
fi

TMPDIR=qfish2_1.0.0

make -C tools
make -C images clean
make -C images

tmake -o Makefile qfish.pro
make

mkdir ${TMPDIR}
cd ${TMPDIR}
mkdir -p opt/QtPalmtop/apps/Games
mkdir -p opt/QtPalmtop/bin
mkdir -p opt/QtPalmtop/pics
mkdir -p opt/QtPalmtop/help/html
mkdir -p CONTROL
mkdir -p opt/QtPalmtop/sounds/qfish2

cp ../desktop/${DESKTOP_FILE} opt/QtPalmtop/apps/Games/qfish2.desktop
cp ../qfish opt/QtPalmtop/bin/qfish2
cp ../desktop/qfish2.png opt/QtPalmtop/pics/qfish2.png
cp ../desktop/qfish.html opt/QtPalmtop/help/html/qfish2.html
cp ../desktop/qfish.control CONTROL/control
cp ../sounds/*.wav opt/QtPalmtop/sounds/qfish2
cp ../desktop/qfish.prerm CONTROL/prerm

cd ..
ipkg-build ${TMPDIR}
rm -rf ${TMPDIR}

